/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.converter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.openmeetings.core.converter.ConversionException;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.file.FileItemLogDao;
import org.apache.openmeetings.db.dao.record.RecordingChunkDao;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.record.RecordingChunk;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.process.ProcessHelper;
import org.apache.openmeetings.util.process.ProcessResult;
import org.apache.openmeetings.util.process.ProcessResultList;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseConverter {
    private static final Logger log = LoggerFactory.getLogger(BaseConverter.class);
    private static final Pattern p = Pattern.compile("\\d{2,5}(x)\\d{2,5}");
    public static final String EXEC_EXT = System.getProperty("os.name").toUpperCase(Locale.ROOT).indexOf("WINDOWS") < 0 ? "" : ".exe";
    private static final int MINUTE_MULTIPLIER = 60000;
    public static final int TIME_TO_WAIT_FOR_FRAME = 300000;
    public static final double HALF_STEP = 0.5;
    @Autowired
    protected ConfigurationDao cfgDao;
    @Autowired
    protected RecordingChunkDao chunkDao;
    @Autowired
    protected FileItemLogDao logDao;
    @Autowired
    protected RecordingDao recordingDao;

    private String getPath(String key, String app) {
        String cfg = this.cfgDao.getString(key, "");
        StringBuilder path = new StringBuilder(cfg);
        if (!Strings.isEmpty((CharSequence)path) && !cfg.endsWith(File.separator)) {
            path.append(File.separator);
        }
        path.append(app).append(EXEC_EXT);
        return path.toString();
    }

    public String getPathToFFMPEG() {
        return this.getPath("path.ffmpeg", "ffmpeg");
    }

    protected String getPathToSoX() {
        return this.getPath("path.sox", "sox");
    }

    protected String getPathToConvert() {
        return this.getPath("path.imagemagick", "convert");
    }

    protected File getStreamFolder(Recording recording) {
        return OmFileHelper.getStreamsSubDir((Long)recording.getRoomId());
    }

    protected long diff(Date from, Date to) {
        return from == null || to == null ? 0L : from.getTime() - to.getTime();
    }

    protected double diffSeconds(Date from, Date to) {
        return this.diffSeconds(this.diff(from, to));
    }

    protected double diffSeconds(long val) {
        return (double)val / 1000.0;
    }

    protected void updateDuration(Recording r) {
        r.setDuration(CalendarHelper.formatMillis((long)this.diff(r.getRecordEnd(), r.getRecordStart())));
    }

    protected void deleteFileIfExists(File f) {
        if (f.exists()) {
            f.delete();
        }
    }

    private List<String> mergeAudioToWaves(List<File> waveFiles, File wav) throws IOException {
        ArrayList<String> argv = new ArrayList<String>();
        argv.add(this.getPathToSoX());
        argv.add("-m");
        for (File arg : waveFiles) {
            argv.add(arg.getCanonicalPath());
        }
        argv.add(wav.getCanonicalPath());
        return argv;
    }

    protected void createWav(Recording r, ProcessResultList logs, File streamFolder, List<File> waveFiles, File wav, List<RecordingChunk> chunks) throws IOException {
        this.deleteFileIfExists(wav);
        this.stripAudioFirstPass(r, logs, waveFiles, streamFolder, chunks == null ? this.chunkDao.getNotScreenChunksByRecording(r.getId()) : chunks);
        if (waveFiles.isEmpty()) {
            String oneSecWav = new File(OmFileHelper.getPublicDir(), "one_second.wav").getCanonicalPath();
            double duration = this.diffSeconds(r.getRecordEnd(), r.getRecordStart());
            List<String> cmd = List.of(this.getPathToSoX(), oneSecWav, wav.getCanonicalPath(), "pad", "0", String.valueOf(duration));
            logs.add(ProcessHelper.exec((String)"generateSampleAudio", cmd));
        } else if (waveFiles.size() == 1) {
            FileUtils.copyFile((File)waveFiles.get(0), (File)wav);
        } else {
            logs.add(ProcessHelper.exec((String)"mergeAudioToWaves", this.mergeAudioToWaves(waveFiles, wav)));
        }
    }

    private List<String> addSoxPad(ProcessResultList logs, String job, double length, double position, File inFile, File outFile) throws IOException {
        if (length < 0.0 || position < 0.0) {
            log.debug("::addSoxPad {} Invalid parameters: length = {}; position = {}; inFile = {}", new Object[]{job, length, position, inFile});
        }
        List<String> argv = List.of(this.getPathToSoX(), inFile.getCanonicalPath(), outFile.getCanonicalPath(), "pad", String.valueOf(length < 0.0 ? 0.0 : length), String.valueOf(position < 0.0 ? 0.0 : position));
        logs.add(ProcessHelper.exec((String)job, argv));
        return argv;
    }

    public static void printChunkInfo(RecordingChunk chunk, String prefix) {
        if (log.isDebugEnabled()) {
            log.debug("### {}:: recording id {}; stream with id {}; current status: {} ", new Object[]{prefix, chunk.getRecording().getId(), chunk.getId(), chunk.getStreamStatus()});
            File chunkFlv = OmFileHelper.getRecordingChunk((Long)chunk.getRecording().getRoomId(), (String)chunk.getStreamName());
            log.debug("### {}:: Chunk file [{}] exists ? {}; size: {}, lastModified: {} ", new Object[]{prefix, chunkFlv.getPath(), chunkFlv.exists(), chunkFlv.length(), chunkFlv.lastModified()});
        }
    }

    protected RecordingChunk waitForTheStream(long chunkId) {
        RecordingChunk chunk;
        block7: {
            chunk = this.chunkDao.get(Long.valueOf(chunkId));
            try {
                if (chunk.getStreamStatus() == RecordingChunk.Status.STOPPED) break block7;
                log.debug("### Chunk Stream not yet written to disk {}", (Object)chunkId);
                long counter = 0L;
                long maxTimestamp = 0L;
                while (true) {
                    log.trace("### Stream not yet written Thread Sleep - {}", (Object)chunkId);
                    chunk = this.chunkDao.get(Long.valueOf(chunkId));
                    if (chunk.getStreamStatus() == RecordingChunk.Status.STOPPED) {
                        BaseConverter.printChunkInfo(chunk, "Stream now written");
                        log.debug("### Thread continue ... ");
                        break;
                    }
                    File chunkFlv = OmFileHelper.getRecordingChunk((Long)chunk.getRecording().getRoomId(), (String)chunk.getStreamName());
                    if (chunkFlv.exists() && maxTimestamp < chunkFlv.lastModified()) {
                        maxTimestamp = chunkFlv.lastModified();
                    }
                    if (maxTimestamp + 300000L < System.currentTimeMillis()) {
                        log.debug("### long time without any update, closing ... ");
                        chunk.setStreamStatus(RecordingChunk.Status.STOPPED);
                        this.chunkDao.update(chunk);
                        break;
                    }
                    if (++counter % 1000L == 0L) {
                        BaseConverter.printChunkInfo(chunk, "Still waiting");
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return chunk;
    }

    private void stripAudioFirstPass(Recording recording, ProcessResultList logs, List<File> waveFiles, File streamFolder, List<RecordingChunk> chunks) {
        try {
            log.debug("### Chunks count - {}", (Object)chunks.size());
            log.debug("###################################################");
            for (RecordingChunk chunk : chunks) {
                long chunkId = chunk.getId();
                log.debug("### processing chunk: {}", (Object)chunkId);
                if (chunk.getStreamStatus() == RecordingChunk.Status.NONE) {
                    log.debug("Stream has not been started, error in recording {}", (Object)chunkId);
                    continue;
                }
                chunk = this.waitForTheStream(chunkId);
                File inputFlvFile = OmFileHelper.getRecordingChunk((Long)chunk.getRecording().getRoomId(), (String)chunk.getStreamName());
                File outputWav = new File(streamFolder, chunk.getStreamName() + "_WAVE.wav");
                log.debug("FLV File Name: {} Length: {} ", (Object)inputFlvFile.getName(), (Object)inputFlvFile.length());
                if (inputFlvFile.exists()) {
                    List<String> argv = List.of(this.getPathToFFMPEG(), "-y", "-i", inputFlvFile.getCanonicalPath(), "-af", String.format("aresample=%s:min_comp=0.001:min_hard_comp=0.100000", OpenmeetingsVariables.getAudioBitrate()), outputWav.getCanonicalPath());
                    logs.add(ProcessHelper.exec((String)"stripAudioFromFLVs", argv, (boolean)true));
                }
                if (outputWav.exists() && outputWav.length() != 0L) {
                    String hashFileFullName = chunk.getStreamName() + "_FULL_WAVE.wav";
                    File outputFullWav = new File(streamFolder, hashFileFullName);
                    double startPad = this.diffSeconds(chunk.getStart(), recording.getRecordStart());
                    double endPad = this.diffSeconds(recording.getRecordEnd(), chunk.getEnd());
                    this.addSoxPad(logs, "addStartEndToAudio", startPad, endPad, outputWav, outputFullWav);
                    log.debug("############################################");
                    log.debug("Trim Audio to Full Length -- Start");
                    if (!outputFullWav.exists()) {
                        throw new ConversionException("Audio File does not exist , could not extract the Audio correctly");
                    }
                    waveFiles.add(outputFullWav);
                }
                this.chunkDao.update(chunk);
            }
        }
        catch (Exception err) {
            log.error("[stripAudioFirstPass]", (Throwable)err);
        }
    }

    protected String getDimensions(Recording r, char delim) {
        return String.format("%s%s%s", r.getWidth(), Character.valueOf(delim), r.getHeight());
    }

    protected String getDimensions(Recording r) {
        return this.getDimensions(r, 'x');
    }

    protected List<String> additionalMp4OutParams(Recording r) {
        return List.of();
    }

    private List<String> addMp4OutParams(Recording r, List<String> argv, boolean interview, String mp4path) {
        argv.addAll(List.of("-c:v", "h264", "-crf", "24", "-vsync", "0", "-pix_fmt", "yuv420p", "-preset", OpenmeetingsVariables.getVideoPreset(), "-profile:v", "baseline", "-level", "3.0", "-movflags", "faststart", "-c:a", "aac", "-ar", String.valueOf(OpenmeetingsVariables.getAudioRate()), "-b:a", OpenmeetingsVariables.getAudioBitrate()));
        if (!interview) {
            argv.addAll(List.of("-vf", "pad=ceil(iw/2)*2:ceil(ih/2)*2"));
        }
        argv.addAll(this.additionalMp4OutParams(r));
        argv.add(mp4path);
        return argv;
    }

    protected String convertToMp4(Recording r, List<String> inArgv, boolean interview, ProcessResultList logs) throws IOException {
        String mp4path = r.getFile().getCanonicalPath();
        ArrayList<String> argv = new ArrayList<String>(List.of(this.getPathToFFMPEG(), "-y"));
        argv.addAll(inArgv);
        logs.add(ProcessHelper.exec((String)"generate MP4", this.addMp4OutParams(r, argv, interview, mp4path)));
        return mp4path;
    }

    protected void convertToPng(BaseFileItem f, String mp4path, ProcessResultList logs) throws IOException {
        File png = f.getFile("png");
        List<String> argv = List.of(this.getPathToFFMPEG(), "-y", "-i", mp4path, "-vf", "thumbnail,scale=640:-1", "-frames:v", "1", png.getCanonicalPath());
        logs.add(ProcessHelper.exec((String)("generate preview PNG :: " + f.getHash()), argv));
    }

    protected static Dimension getDimension(String txt, Dimension def) {
        Matcher matcher = p.matcher(txt);
        if (matcher.find()) {
            String foundResolution = txt.substring(matcher.start(), matcher.end());
            String[] resolutions = foundResolution.split("x");
            return new Dimension(NumberUtils.toInt((String)resolutions[0]), NumberUtils.toInt((String)resolutions[1]));
        }
        return def;
    }

    protected void finalizeRec(Recording r, String mp4path, ProcessResultList logs) throws IOException {
        this.convertToPng((BaseFileItem)r, mp4path, logs);
        this.updateDuration(r);
        r.setStatus(Recording.Status.PROCESSED);
    }

    protected void postProcess(Recording r, ProcessResultList logs) {
        this.logDao.delete((BaseFileItem)r);
        for (ProcessResult res : logs.getJobs()) {
            this.logDao.add("generateFFMPEG", (BaseFileItem)r, res);
        }
    }

    protected void postProcess(List<File> waveFiles) {
        for (File audio : waveFiles) {
            if (!audio.exists()) continue;
            audio.delete();
        }
    }

    protected static class Dimension {
        private final int width;
        private final int height;

        public Dimension(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

