/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.mail.template.subject;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.service.mail.template.DashOmTextLabel;
import org.apache.openmeetings.service.mail.template.OmTextLabel;
import org.apache.openmeetings.service.mail.template.subject.SubjectEmailTemplate;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.util.string.Strings;

public abstract class AppointmentTemplate
extends SubjectEmailTemplate {
    private static final long serialVersionUID = 1L;
    protected Appointment a;
    protected TimeZone tz;

    AppointmentTemplate(Locale locale, Appointment a, TimeZone tz) {
        super(locale);
        this.a = a;
        this.tz = tz;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("title", (Serializable)((Object)this.a.getTitle()))});
        this.add(new Component[]{new WebMarkupContainer("descContainer").add(new Component[]{new Label("descLbl", (Serializable)((Object)this.getString("1152", this.locale, new String[0])))}).add(new Component[]{new Label("desc", (Serializable)((Object)this.a.getDescription())).setEscapeModelStrings(false)}).setVisible(!Strings.isEmpty((CharSequence)this.a.getDescription()))});
        this.add(new Component[]{new Label("startLbl", (Serializable)((Object)this.getString("label.start", this.locale, new String[0])))});
        this.add(new Component[]{new Label("start", (Serializable)((Object)this.format(this.a.getStart())))});
        this.add(new Component[]{new Label("endLbl", (Serializable)((Object)this.getString("label.end", this.locale, new String[0])))});
        this.add(new Component[]{new Label("end", (Serializable)((Object)this.format(this.a.getEnd())))});
    }

    abstract String getPrefix();

    @Override
    Fragment getSubjectFragment() {
        Fragment f = new Fragment("template", "subject", (MarkupContainer)this);
        f.add(new Component[]{new OmTextLabel("prefix", this.getPrefix()), new OmTextLabel("title", this.a.getTitle()), new OmTextLabel("start", this.format(this.a.getStart(), 3)), new DashOmTextLabel("dash"), new OmTextLabel("end", this.format(this.a.getEnd(), 3))});
        return f;
    }

    protected String format(Date d) {
        return this.format(d, 2);
    }

    protected String format(Date d, int fmt) {
        return FastDateFormat.getDateTimeInstance((int)fmt, (int)fmt, (TimeZone)this.tz, (Locale)this.locale).format(d);
    }
}

