/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.calendar.caldav.handler;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.model.response.CalendarDataProperty;
import java.io.IOException;
import java.util.Map;
import net.fortuna.ical4j.model.Calendar;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.service.calendar.caldav.IcalUtils;
import org.apache.openmeetings.service.calendar.caldav.handler.AbstractCalendarHandler;
import org.apache.openmeetings.service.calendar.caldav.handler.EtagsHandler;
import org.apache.openmeetings.service.calendar.caldav.methods.SyncMethod;
import org.apache.openmeetings.service.calendar.caldav.methods.SyncReportInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDAVSyncHandler
extends AbstractCalendarHandler {
    private static final Logger log = LoggerFactory.getLogger(WebDAVSyncHandler.class);
    public static final DavPropertyName DNAME_SYNCTOKEN = DavPropertyName.create((String)"sync-token", (Namespace)SyncReportInfo.NAMESPACE);

    public WebDAVSyncHandler(String path, OmCalendar calendar, HttpClient client, HttpClientContext context, AppointmentDao appointmentDao, IcalUtils utils) {
        super(path, calendar, client, context, appointmentDao, utils);
    }

    @Override
    BaseDavRequest internalSyncItems() throws IOException, DavException {
        Long ownerId = this.calendar.getOwner().getId();
        boolean additionalSyncNeeded = false;
        DavPropertyNameSet properties = new DavPropertyNameSet();
        properties.add(DavPropertyName.GETETAG);
        properties.add(CalDAVConstants.DNAME_CALENDAR_DATA);
        SyncReportInfo reportInfo = new SyncReportInfo(this.calendar.getToken(), properties, 1);
        SyncMethod method = new SyncMethod(this.path, reportInfo);
        HttpResponse httpResponse = this.client.execute((HttpUriRequest)method, (HttpContext)this.context);
        if (method.succeeded(httpResponse)) {
            Map<String, Appointment> map = WebDAVSyncHandler.listToMap(this.appointmentDao.getbyCalendar(this.calendar.getId()));
            for (MultiStatusResponse response : method.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
                Appointment a;
                int status = response.getStatus()[0].getStatusCode();
                if (status == 200) {
                    a = map.get(response.getHref());
                    if (a != null) {
                        String origetag = a.getEtag();
                        String currentetag = CalendarDataProperty.getEtagfromResponse((MultiStatusResponse)response);
                        if (currentetag.equals(origetag)) continue;
                        Calendar calendar = CalendarDataProperty.getCalendarfromResponse((MultiStatusResponse)response);
                        a = this.utils.parseCalendartoAppointment(a, calendar, currentetag);
                        this.appointmentDao.update(a, ownerId);
                        continue;
                    }
                    String etag = CalendarDataProperty.getEtagfromResponse((MultiStatusResponse)response);
                    Calendar ical = CalendarDataProperty.getCalendarfromResponse((MultiStatusResponse)response);
                    Appointment appointments = this.utils.parseCalendartoAppointment(ical, response.getHref(), etag, this.calendar);
                    this.appointmentDao.update(appointments, ownerId);
                    continue;
                }
                if (status == 404) {
                    a = map.get(response.getHref());
                    if (a == null) continue;
                    this.appointmentDao.delete(a, this.calendar.getOwner().getId());
                    continue;
                }
                if (status != 507) continue;
                additionalSyncNeeded = true;
            }
            this.calendar.setToken(method.getResponseSynctoken(httpResponse));
        } else if (httpResponse.getStatusLine().getStatusCode() == 403 || httpResponse.getStatusLine().getStatusCode() == 412) {
            log.info("Sync Token not accepted by server. Doing a full sync again.");
            this.calendar.setToken(null);
            additionalSyncNeeded = true;
        } else {
            log.error("Error in Sync Method Response with status code {}", (Object)httpResponse.getStatusLine().getStatusCode());
        }
        if (additionalSyncNeeded) {
            this.releaseConnection((HttpRequestBase)method);
            return this.internalSyncItems();
        }
        return method;
    }

    @Override
    public boolean updateItem(Appointment appointment) {
        EtagsHandler etagsHandler = new EtagsHandler(this.path, this.calendar, this.client, this.context, this.appointmentDao, this.utils);
        return etagsHandler.updateItem(appointment);
    }

    @Override
    public boolean deleteItem(Appointment appointment) {
        EtagsHandler etagsHandler = new EtagsHandler(this.path, this.calendar, this.client, this.context, this.appointmentDao, this.utils);
        return etagsHandler.deleteItem(appointment);
    }
}

