/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.calendar.caldav.handler;

import com.github.caldav4j.methods.HttpPropFindMethod;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.service.calendar.caldav.AppointmentManager;
import org.apache.openmeetings.service.calendar.caldav.IcalUtils;
import org.apache.openmeetings.service.calendar.caldav.handler.AbstractCalendarHandler;
import org.apache.openmeetings.service.calendar.caldav.handler.EtagsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtagHandler
extends AbstractCalendarHandler {
    private static final Logger log = LoggerFactory.getLogger(CtagHandler.class);
    public static final Namespace NAMESPACE_CALSERVER = Namespace.getNamespace((String)"cs", (String)"http://calendarserver.org/ns/");
    public static final DavPropertyName DNAME_GETCTAG = DavPropertyName.create((String)"getctag", (Namespace)NAMESPACE_CALSERVER);

    public CtagHandler(String path, OmCalendar calendar, HttpClient client, HttpClientContext context, AppointmentDao appointmentDao, IcalUtils utils) {
        super(path, calendar, client, context, appointmentDao, utils);
    }

    @Override
    BaseDavRequest internalSyncItems() throws IOException, DavException {
        DavPropertyNameSet properties = new DavPropertyNameSet();
        properties.add(DNAME_GETCTAG);
        HttpPropFindMethod method = new HttpPropFindMethod(this.path, properties, 0);
        HttpResponse httpResponse = this.client.execute((HttpUriRequest)method, (HttpContext)this.context);
        if (method.succeeded(httpResponse)) {
            for (MultiStatusResponse response : method.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
                DavPropertySet set = response.getProperties(200);
                String ctag = AppointmentManager.getTokenFromProperty(set.get(DNAME_GETCTAG));
                if (ctag == null || ctag.equals(this.calendar.getToken())) continue;
                EtagsHandler etagsHandler = new EtagsHandler(this.path, this.calendar, this.client, this.context, this.appointmentDao, this.utils);
                etagsHandler.syncItems();
                this.calendar.setToken(ctag);
            }
        } else {
            log.error("Error executing PROPFIND Method, with status Code: {}", (Object)httpResponse.getStatusLine().getStatusCode());
        }
        return method;
    }

    @Override
    public boolean updateItem(Appointment appointment) {
        EtagsHandler etagsHandler = new EtagsHandler(this.path, this.calendar, this.client, this.context, this.appointmentDao, this.utils);
        return etagsHandler.updateItem(appointment);
    }

    @Override
    public boolean deleteItem(Appointment appointment) {
        EtagsHandler etagsHandler = new EtagsHandler(this.path, this.calendar, this.client, this.context, this.appointmentDao, this.utils);
        return etagsHandler.deleteItem(appointment);
    }
}

