/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.impl.CommonConfig;
import com.fasterxml.aalto.out.WNameFactory;
import com.fasterxml.aalto.out.WNameTable;
import com.fasterxml.aalto.util.BufferRecycler;
import java.lang.ref.SoftReference;
import java.util.HashMap;

public final class WriterConfig
extends CommonConfig {
    protected static final String DEFAULT_AUTOMATIC_NS_PREFIX = "ans";
    static final int F_NS_REPAIRING = 1;
    static final int F_AUTO_CLOSE_OUTPUT = 16;
    static final int F_NS_AWARE = 32;
    static final int F_AUTO_EMPTY_ELEMS = 64;
    static final int PROP_AUTO_NS_PREFIX = -2;
    static final int DEFAULT_FLAGS = 32;
    private static final HashMap<String, Integer> sProperties = new HashMap();
    private String _propAutoNsPrefix;
    private final EncodingContext _encodingContext;
    private String _encoding;
    static final ThreadLocal<SoftReference<BufferRecycler>> mRecyclerRef;
    BufferRecycler _currRecycler = null;

    private WriterConfig(String encoding, int flags, int flagMods, EncodingContext encCtxt, String autoNsPrefix) {
        super(flags, flagMods);
        this._encoding = encoding;
        this._encodingContext = encCtxt;
        SoftReference<BufferRecycler> ref = mRecyclerRef.get();
        if (ref != null) {
            this._currRecycler = ref.get();
        }
        this._flags = flags;
        this._flagMods = flagMods;
        this._propAutoNsPrefix = autoNsPrefix;
    }

    public WriterConfig() {
        this(null, 32, 0, new EncodingContext(), DEFAULT_AUTOMATIC_NS_PREFIX);
    }

    public void setActualEncodingIfNotSet(String enc) {
        if (this._encoding == null || this._encoding.length() == 0) {
            this._encoding = enc;
        }
    }

    public void doAutoCloseOutput(boolean state) {
        this.setFlag(16, state);
    }

    public void enableXml11() {
    }

    public WriterConfig createNonShared() {
        return new WriterConfig(this._encoding, this._flags, this._flagMods, this._encodingContext, this._propAutoNsPrefix);
    }

    @Override
    public boolean isXml11() {
        return false;
    }

    @Override
    public String getExternalEncoding() {
        return this.getActualEncoding();
    }

    @Override
    public String getActualEncoding() {
        return this._encoding;
    }

    public String getPreferredEncoding() {
        return this._encoding;
    }

    @Override
    public Object getProperty(String name, boolean isMandatory) {
        Integer I = sProperties.get(name);
        if (I == null) {
            if (sProperties.containsKey(name)) {
                return null;
            }
            return super.getProperty(name, isMandatory);
        }
        int f = I;
        if (f >= 0) {
            return this.hasFlag(f);
        }
        switch (f) {
            case -2: {
                return this._propAutoNsPrefix;
            }
        }
        return null;
    }

    @Override
    public boolean setProperty(String name, Object value) {
        Integer I = sProperties.get(name);
        if (I == null) {
            if (sProperties.containsKey(name)) {
                return false;
            }
            return super.setProperty(name, value);
        }
        int f = I;
        if (f >= 0) {
            boolean state = (Boolean)value;
            if (f == 32 && !state) {
                return false;
            }
            this.setFlag(f, state);
            return true;
        }
        switch (f) {
            case -2: {
                this._propAutoNsPrefix = value.toString();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPropertySupported(String propName) {
        return sProperties.containsKey(propName) || super.isPropertySupported(propName);
    }

    public boolean willRepairNamespaces() {
        return this.hasFlag(1);
    }

    public boolean isNamespaceAware() {
        return this.hasFlag(32);
    }

    public boolean willAutoCloseOutput() {
        return this.hasFlag(16);
    }

    public String getAutomaticNsPrefix() {
        return this._propAutoNsPrefix;
    }

    public void configureForXmlConformance() {
    }

    public void configureForRobustness() {
    }

    public void configureForSpeed() {
    }

    public boolean willCheckStructure() {
        return true;
    }

    public boolean willCheckContent() {
        return true;
    }

    public boolean willCheckNames() {
        return false;
    }

    public boolean willCheckAttributes() {
        return false;
    }

    public boolean willFixContent() {
        return true;
    }

    public boolean willEscapeCR() {
        return true;
    }

    public char[] allocSmallCBuffer(int minSize) {
        char[] result;
        if (this._currRecycler != null && (result = this._currRecycler.getSmallCBuffer(minSize)) != null) {
            return result;
        }
        return new char[minSize];
    }

    public void freeSmallCBuffer(char[] buffer) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnSmallCBuffer(buffer);
    }

    public char[] allocMediumCBuffer(int minSize) {
        char[] result;
        if (this._currRecycler != null && (result = this._currRecycler.getMediumCBuffer(minSize)) != null) {
            return result;
        }
        return new char[minSize];
    }

    public void freeMediumCBuffer(char[] buffer) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnMediumCBuffer(buffer);
    }

    public char[] allocFullCBuffer(int minSize) {
        char[] result;
        if (this._currRecycler != null && (result = this._currRecycler.getFullCBuffer(minSize)) != null) {
            return result;
        }
        return new char[minSize];
    }

    public void freeFullCBuffer(char[] buffer) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnFullCBuffer(buffer);
    }

    public byte[] allocFullBBuffer(int minSize) {
        byte[] result;
        if (this._currRecycler != null && (result = this._currRecycler.getFullBBuffer(minSize)) != null) {
            return result;
        }
        return new byte[minSize];
    }

    public void freeFullBBuffer(byte[] buffer) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnFullBBuffer(buffer);
    }

    private BufferRecycler createRecycler() {
        BufferRecycler recycler = new BufferRecycler();
        mRecyclerRef.set(new SoftReference<BufferRecycler>(recycler));
        return recycler;
    }

    public WNameTable getUtf8Symbols(WNameFactory f) {
        return this._encodingContext.getUtf8Symbols(f);
    }

    public WNameTable getLatin1Symbols(WNameFactory f) {
        return this._encodingContext.getLatin1Symbols(f);
    }

    public WNameTable getAsciiSymbols(WNameFactory f) {
        return this._encodingContext.getAsciiSymbols(f);
    }

    public WNameTable getCharSymbols(WNameFactory f) {
        return this._encodingContext.getCharSymbols(f);
    }

    static {
        sProperties.put("org.apache.olingo.javax.xml.stream.isRepairingNamespaces", 1);
        sProperties.put("org.apache.olingo.javax.xml.stream.isNamespaceAware", 32);
        sProperties.put("org.apache.olingo.javax.xml.stream.reporter", null);
        sProperties.put("org.codehaus.stax2.autoCloseOutput", 16);
        sProperties.put("org.codehaus.stax2.automaticEmptyElements", 64);
        sProperties.put("org.codehaus.stax2.automaticNsPrefix", -2);
        sProperties.put("org.codehaus.stax2.textEscaper", null);
        sProperties.put("org.codehaus.stax2.attrValueEscaper", null);
        mRecyclerRef = new ThreadLocal();
    }

    static final class EncodingContext {
        WNameTable mUtf8Table;
        WNameTable mLatin1Table;
        WNameTable mAsciiTable;
        WNameTable mCharTable;

        EncodingContext() {
        }

        public synchronized WNameTable getUtf8Symbols(WNameFactory f) {
            if (this.mUtf8Table == null) {
                this.mUtf8Table = new WNameTable(64);
            }
            return this.mUtf8Table.createChild(f);
        }

        public synchronized WNameTable getLatin1Symbols(WNameFactory f) {
            if (this.mLatin1Table == null) {
                this.mLatin1Table = new WNameTable(64);
            }
            return this.mLatin1Table.createChild(f);
        }

        public synchronized WNameTable getAsciiSymbols(WNameFactory f) {
            if (this.mAsciiTable == null) {
                this.mAsciiTable = new WNameTable(64);
            }
            return this.mAsciiTable.createChild(f);
        }

        public synchronized WNameTable getCharSymbols(WNameFactory f) {
            if (this.mCharTable == null) {
                this.mCharTable = new WNameTable(64);
            }
            return this.mCharTable.createChild(f);
        }
    }
}

