/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.response.batch;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchLineIterator;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchResponseItem;
import org.apache.olingo.client.api.communication.response.ODataBatchResponse;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchLineIteratorImpl;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchUtilities;
import org.apache.olingo.client.core.communication.request.batch.ODataChangesetResponseItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataBatchResponseManager
implements Iterator<ODataBatchResponseItem> {
    private static final Logger LOG = LoggerFactory.getLogger(ODataBatchResponseManager.class);
    private final ODataBatchLineIterator batchLineIterator;
    private final String batchBoundary;
    private final Iterator<ODataBatchResponseItem> expectedItemsIterator;
    private ODataBatchResponseItem current = null;
    private final boolean continueOnError;

    public ODataBatchResponseManager(ODataBatchResponse res, List<ODataBatchResponseItem> expectedItems) {
        this(res, expectedItems, false);
    }

    public ODataBatchResponseManager(ODataBatchResponse res, List<ODataBatchResponseItem> expectedItems, boolean continueOnError) {
        this.continueOnError = continueOnError;
        try {
            this.expectedItemsIterator = expectedItems.iterator();
            this.batchLineIterator = new ODataBatchLineIteratorImpl(IOUtils.lineIterator(res.getRawResponse(), "UTF-8"));
            this.batchBoundary = ODataBatchUtilities.getBoundaryFromHeader(res.getHeader("Content-Type"));
            LOG.debug("Retrieved batch response bondary '{}'", (Object)this.batchBoundary);
        }
        catch (IOException e) {
            LOG.error("Error parsing batch response", e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return (this.current == null || this.continueOnError || !this.current.isBreaking()) && this.expectedItemsIterator.hasNext();
    }

    @Override
    public ODataBatchResponseItem next() {
        if (this.current != null) {
            this.current.close();
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("No item found");
        }
        this.current = this.expectedItemsIterator.next();
        Map<String, Collection<String>> nextItemHeaders = ODataBatchUtilities.nextItemHeaders(this.batchLineIterator, this.batchBoundary);
        switch (ODataBatchUtilities.getItemType(nextItemHeaders)) {
            case CHANGESET: {
                if (!this.current.isChangeset()) {
                    throw new IllegalStateException("Unexpected batch item");
                }
                this.current.initFromBatch(this.batchLineIterator, ODataBatchUtilities.getBoundaryFromHeader(nextItemHeaders.get("Content-Type")));
                break;
            }
            case RETRIEVE: {
                if (this.current.isChangeset()) {
                    ((ODataChangesetResponseItem)this.current).setUnexpected();
                }
                this.current.initFromBatch(this.batchLineIterator, this.batchBoundary);
                break;
            }
            default: {
                throw new IllegalStateException("Expected item not found");
            }
        }
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operation is not supported");
    }
}

