/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.response;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchLineIterator;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.http.NoContentException;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchController;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchLineIteratorImpl;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchUtilities;
import org.apache.olingo.client.core.communication.util.PipedInputStream;
import org.apache.olingo.client.core.communication.util.PipedOutputStream;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractODataResponse
implements ODataResponse {
    protected static final Logger LOG = LoggerFactory.getLogger(ODataResponse.class);
    protected final ODataClient odataClient;
    private static final byte[] CRLF = new byte[]{13, 10};
    protected final HttpClient httpClient;
    protected final HttpResponse res;
    protected final Map<String, Collection<String>> headers = new TreeMap<String, Collection<String>>(String.CASE_INSENSITIVE_ORDER);
    protected int statusCode = -1;
    protected String statusMessage = null;
    protected InputStream payload = null;
    protected boolean hasBeenInitialized = false;
    protected ODataBatchController batchInfo = null;
    private byte[] inputContent = null;

    public AbstractODataResponse(ODataClient odataClient, HttpClient httpclient, HttpResponse res) {
        this.odataClient = odataClient;
        this.httpClient = httpclient;
        this.res = res;
        if (res != null) {
            this.initFromHttpResponse(res);
        }
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public Collection<String> getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public String getETag() {
        Collection<String> etag = this.getHeader("ETag");
        return etag == null || etag.isEmpty() ? null : etag.iterator().next();
    }

    @Override
    public String getContentType() {
        Collection<String> contentTypes = this.getHeader("Content-Type");
        return contentTypes == null || contentTypes.isEmpty() ? null : contentTypes.iterator().next();
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public final ODataResponse initFromHttpResponse(HttpResponse res) {
        try {
            this.payload = res.getEntity() == null ? null : res.getEntity().getContent();
            this.inputContent = null;
        }
        catch (IOException | IllegalStateException e) {
            HttpClientUtils.closeQuietly((HttpResponse)res);
            LOG.error("Error retrieving payload", e);
            throw new ODataRuntimeException(e);
        }
        for (Header header : res.getAllHeaders()) {
            Collection<Object> headerValues;
            if (this.headers.containsKey(header.getName())) {
                headerValues = this.headers.get(header.getName());
            } else {
                headerValues = new HashSet();
                this.headers.put(header.getName(), headerValues);
            }
            headerValues.add(header.getValue());
        }
        this.statusCode = res.getStatusLine().getStatusCode();
        this.statusMessage = res.getStatusLine().getReasonPhrase();
        this.hasBeenInitialized = true;
        return this;
    }

    @Override
    public ODataResponse initFromBatch(Map.Entry<Integer, String> responseLine, Map<String, Collection<String>> headers, ODataBatchLineIterator batchLineIterator, String boundary) {
        if (this.hasBeenInitialized) {
            throw new IllegalStateException("Request already initialized");
        }
        this.batchInfo = new ODataBatchController(batchLineIterator, boundary);
        this.statusCode = responseLine.getKey();
        this.statusMessage = responseLine.getValue();
        this.headers.putAll(headers);
        this.hasBeenInitialized = true;
        return this;
    }

    @Override
    public ODataResponse initFromEnclosedPart(InputStream part) {
        try {
            if (this.hasBeenInitialized) {
                throw new IllegalStateException("Request already initialized");
            }
            ODataBatchLineIteratorImpl batchLineIterator = new ODataBatchLineIteratorImpl(IOUtils.lineIterator(part, "UTF-8"));
            Map.Entry<Integer, String> partResponseLine = ODataBatchUtilities.readResponseLine(batchLineIterator);
            LOG.debug("Retrieved async item response {}", (Object)partResponseLine);
            this.statusCode = partResponseLine.getKey();
            this.statusMessage = partResponseLine.getValue();
            Map<String, Collection<String>> partHeaders = ODataBatchUtilities.readHeaders(batchLineIterator);
            LOG.debug("Retrieved async item headers {}", (Object)partHeaders);
            this.headers.putAll(partHeaders);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (batchLineIterator.hasNext()) {
                bos.write(batchLineIterator.nextLine().getBytes("UTF-8"));
                bos.write(CRLF);
            }
            try {
                this.payload = new ByteArrayInputStream(bos.toByteArray());
            }
            catch (Exception e) {
                LOG.error("Error retrieving payload", e);
                throw new IllegalStateException(e);
            }
            this.hasBeenInitialized = true;
            return this;
        }
        catch (IOException e) {
            LOG.error("Error streaming payload response", e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        this.odataClient.getConfiguration().getHttpClientFactory().close(this.httpClient);
        if (this.batchInfo != null) {
            this.batchInfo.setValidBatch(false);
        }
    }

    @Override
    public InputStream getRawResponse() {
        ByteArrayInputStream inputStream = null;
        if (204 == this.getStatusCode()) {
            throw new NoContentException();
        }
        if (this.payload == null && this.batchInfo != null && this.batchInfo.isValidBatch()) {
            this.payload = new PipedInputStream(null);
            try {
                final PipedOutputStream os = new PipedOutputStream((PipedInputStream)this.payload, 0x400000);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ODataBatchUtilities.readBatchPart(AbstractODataResponse.this.batchInfo, os, true);
                        }
                        catch (Exception e) {
                            LOG.error("Error streaming batch item payload", e);
                        }
                        finally {
                            IOUtils.closeQuietly(os);
                        }
                    }
                }).start();
            }
            catch (Exception e) {
                LOG.error("Error streaming payload response", e);
                throw new IllegalStateException(e);
            }
        } else if (this.payload != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                IOUtils.copy(this.payload, (OutputStream)byteArrayOutputStream);
                if (this.inputContent == null) {
                    this.inputContent = byteArrayOutputStream.toByteArray();
                }
                inputStream = new ByteArrayInputStream(this.inputContent);
                return inputStream;
            }
            catch (IOException e) {
                HttpClientUtils.closeQuietly((HttpResponse)this.res);
                LOG.error("Error retrieving payload", e);
                throw new ODataRuntimeException(e);
            }
        }
        return this.payload;
    }
}

