/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.client.api.EdmEnabledODataClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.ODataClientErrorException;
import org.apache.olingo.client.core.communication.header.ODataErrorResponseChecker;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequest {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractRequest.class);
    private static final String TEXT_CONTENT_TYPE = "text/plain";

    protected void checkRequest(ODataClient odataClient, HttpUriRequest request) {
        if (odataClient instanceof EdmEnabledODataClient && !request.getURI().toASCIIString().startsWith(((EdmEnabledODataClient)odataClient).getServiceRoot())) {
            throw new IllegalArgumentException(String.format("The current request URI %s does not match the configured service root %s", request.getURI().toASCIIString(), ((EdmEnabledODataClient)odataClient).getServiceRoot()));
        }
    }

    protected void checkResponse(ODataClient odataClient, HttpResponse response, String accept) {
        if (response.getStatusLine().getStatusCode() >= 400) {
            Header contentTypeHeader = response.getEntity() != null ? response.getEntity().getContentType() : null;
            try {
                ODataRuntimeException exception = ODataErrorResponseChecker.checkResponse(odataClient, response.getStatusLine(), response.getEntity() == null ? null : response.getEntity().getContent(), contentTypeHeader != null && contentTypeHeader.getValue().contains(TEXT_CONTENT_TYPE) ? TEXT_CONTENT_TYPE : accept);
                if (exception != null) {
                    if (exception instanceof ODataClientErrorException) {
                        ((ODataClientErrorException)exception).setHeaderInfo(response.getAllHeaders());
                    }
                    throw exception;
                }
            }
            catch (IOException e) {
                throw new ODataRuntimeException("Received '" + response.getStatusLine() + "' but could not extract error body", e);
            }
        }
    }
}

