/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.callback.OnReadInlineContent;
import org.apache.olingo.odata2.api.ep.callback.ReadEntryResult;
import org.apache.olingo.odata2.api.ep.callback.ReadFeedResult;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.NavigationPropertyInfo;
import org.apache.olingo.odata2.core.ep.consumer.JsonFeedConsumer;
import org.apache.olingo.odata2.core.ep.consumer.JsonPropertyConsumer;
import org.apache.olingo.odata2.core.ep.entry.DeletedEntryMetadataImpl;
import org.apache.olingo.odata2.core.ep.entry.EntryMetadataImpl;
import org.apache.olingo.odata2.core.ep.entry.MediaMetadataImpl;
import org.apache.olingo.odata2.core.ep.entry.ODataEntryImpl;
import org.apache.olingo.odata2.core.ep.feed.JsonFeedEntry;
import org.apache.olingo.odata2.core.uri.ExpandSelectTreeNodeImpl;

public class JsonEntryConsumer {
    private final Map<String, Object> typeMappings;
    private final EntityInfoAggregator eia;
    private final JsonReader reader;
    private final EntityProviderReadProperties readProperties;
    private ODataEntryImpl resultEntry;
    private Map<String, Object> properties;
    private MediaMetadataImpl mediaMetadata;
    private EntryMetadataImpl entryMetadata;
    private ExpandSelectTreeNodeImpl expandSelectTree;
    private DeletedEntryMetadataImpl resultDeletedEntry;

    public JsonEntryConsumer(JsonReader reader, EntityInfoAggregator eia, EntityProviderReadProperties readProperties) {
        this.typeMappings = readProperties.getTypeMappings();
        this.eia = eia;
        this.readProperties = readProperties;
        this.reader = reader;
    }

    public ODataEntry readSingleEntry() throws EntityProviderException {
        try {
            this.reader.beginObject();
            String nextName = this.reader.nextName();
            if ("d".equals(nextName)) {
                this.reader.beginObject();
                this.readEntryContent();
                this.reader.endObject();
            } else {
                this.handleName(nextName);
                this.readEntryContent();
            }
            this.reader.endObject();
            if (this.reader.peek() != JsonToken.END_DOCUMENT) {
                throw new EntityProviderException(EntityProviderException.END_DOCUMENT_EXPECTED.addContent(new Object[]{this.reader.peek().toString()}));
            }
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        return this.resultEntry;
    }

    public JsonFeedEntry readFeedEntry() throws EdmException, EntityProviderException, IOException {
        this.reader.beginObject();
        this.readEntryContent();
        this.reader.endObject();
        if (this.resultDeletedEntry == null) {
            return new JsonFeedEntry(this.resultEntry);
        }
        return new JsonFeedEntry(this.resultDeletedEntry);
    }

    private void readEntryContent() throws IOException, EdmException, EntityProviderException {
        while (this.reader.hasNext()) {
            String name = this.reader.nextName();
            this.handleName(name);
        }
    }

    private void ensureODataEntryExists() {
        if (this.resultEntry == null) {
            this.properties = new HashMap<String, Object>();
            this.mediaMetadata = new MediaMetadataImpl();
            this.entryMetadata = new EntryMetadataImpl();
            this.expandSelectTree = new ExpandSelectTreeNodeImpl();
            this.resultEntry = new ODataEntryImpl(this.properties, this.mediaMetadata, this.entryMetadata, this.expandSelectTree);
        }
    }

    private void ensureDeletedEntryMetadataExists() {
        if (this.resultDeletedEntry == null) {
            this.resultDeletedEntry = new DeletedEntryMetadataImpl();
        }
    }

    private void handleName(String name) throws IOException, EdmException, EntityProviderException {
        if ("__metadata".equals(name)) {
            this.ensureODataEntryExists();
            this.readMetadata();
            this.validateMetadata();
        } else if ("@odata.context".equals(name)) {
            this.readODataContext();
        } else {
            this.ensureODataEntryExists();
            EntityPropertyInfo propertyInfo = this.eia.getPropertyInfo(name);
            if (propertyInfo != null) {
                Object propertyValue = new JsonPropertyConsumer().readPropertyValue(this.reader, propertyInfo, this.typeMappings.get(name), this.readProperties);
                if (this.properties.containsKey(name)) {
                    throw new EntityProviderException(EntityProviderException.DOUBLE_PROPERTY.addContent(new Object[]{name}));
                }
                this.properties.put(name, propertyValue);
            } else {
                this.readNavigationProperty(name);
            }
        }
    }

    private void readODataContext() throws IOException, EntityProviderException {
        String contextValue = this.reader.nextString();
        if (contextValue == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"@odata.context"}).addContent(new Object[]{"results"}));
        }
        if (contextValue.startsWith("$metadata#") && contextValue.endsWith("/$deletedEntity")) {
            while (this.reader.hasNext()) {
                this.ensureDeletedEntryMetadataExists();
                String name = this.reader.nextName();
                String value = this.reader.nextString();
                if ("id".equals(name)) {
                    this.resultDeletedEntry.setUri(value);
                    continue;
                }
                if (!"when".equals(name)) continue;
                Date when = this.parseWhen(value);
                this.resultDeletedEntry.setWhen(when);
            }
        }
    }

    private Date parseWhen(String value) throws EntityProviderException {
        try {
            return EdmDateTimeOffset.getInstance().valueOfString(value, EdmLiteralKind.JSON, null, Date.class);
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderException(EntityProviderException.INVALID_DELETED_ENTRY_METADATA.addContent(new Object[]{"Unparsable format for when field value."}));
        }
    }

    private void readMetadata() throws IOException, EdmException, EntityProviderException {
        String name = null;
        String value = null;
        this.reader.beginObject();
        while (this.reader.hasNext()) {
            name = this.reader.nextName();
            if ("properties".equals(name)) {
                this.reader.skipValue();
                continue;
            }
            value = this.reader.nextString();
            if ("id".equals(name)) {
                this.entryMetadata.setId(value);
                continue;
            }
            if ("uri".equals(name)) {
                this.entryMetadata.setUri(value);
                continue;
            }
            if ("type".equals(name)) {
                String fullQualifiedName = this.eia.getEntityType().getNamespace() + "." + this.eia.getEntityType().getName();
                if (fullQualifiedName.equals(value)) continue;
                throw new EntityProviderException(EntityProviderException.INVALID_ENTITYTYPE.addContent(new Object[]{fullQualifiedName}).addContent(new Object[]{value}));
            }
            if ("etag".equals(name)) {
                this.entryMetadata.setEtag(value);
                continue;
            }
            if ("edit_media".equals(name)) {
                this.mediaMetadata.setEditLink(value);
                continue;
            }
            if ("media_src".equals(name)) {
                this.mediaMetadata.setSourceLink(value);
                continue;
            }
            if ("media_etag".equals(name)) {
                this.mediaMetadata.setEtag(value);
                continue;
            }
            if ("content_type".equals(name)) {
                this.mediaMetadata.setContentType(value);
                continue;
            }
            throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent(new Object[]{name}).addContent(new Object[]{"__metadata"}));
        }
        this.reader.endObject();
    }

    private void validateMetadata() throws EdmException, EntityProviderException {
        if (this.eia.getEntityType().hasStream()) {
            if (this.mediaMetadata.getSourceLink() == null) {
                throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"media_src"}).addContent(new Object[]{"__metadata"}));
            }
            if (this.mediaMetadata.getContentType() == null) {
                throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"content_type"}).addContent(new Object[]{"__metadata"}));
            }
        } else if (this.mediaMetadata.getContentType() != null || this.mediaMetadata.getEditLink() != null || this.mediaMetadata.getEtag() != null || this.mediaMetadata.getSourceLink() != null) {
            throw new EntityProviderException(EntityProviderException.MEDIA_DATA_NOT_INITIAL);
        }
    }

    private void readNavigationProperty(String navigationPropertyName) throws IOException, EntityProviderException, EdmException {
        NavigationPropertyInfo navigationPropertyInfo = this.eia.getNavigationPropertyInfo(navigationPropertyName);
        if (navigationPropertyInfo == null) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{navigationPropertyName}));
        }
        JsonToken peek = this.reader.peek();
        if (peek == JsonToken.BEGIN_OBJECT) {
            this.reader.beginObject();
            String name = this.reader.nextName();
            if ("__deferred".equals(name)) {
                this.reader.beginObject();
                String uri = this.reader.nextName();
                if (!"uri".equals(uri)) {
                    throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{uri}));
                }
                String value = this.reader.nextString();
                this.entryMetadata.putAssociationUri(navigationPropertyInfo.getName(), value);
                this.reader.endObject();
            } else {
                EdmNavigationProperty navigationProperty = (EdmNavigationProperty)this.eia.getEntityType().getProperty(navigationPropertyName);
                EdmEntitySet inlineEntitySet = this.eia.getEntitySet().getRelatedEntitySet(navigationProperty);
                EntityInfoAggregator inlineEia = EntityInfoAggregator.create(inlineEntitySet);
                OnReadInlineContent callback = this.readProperties.getCallback();
                try {
                    EntityProviderReadProperties inlineReadProperties = callback == null ? EntityProviderReadProperties.init().mergeSemantic(this.readProperties.getMergeSemantic()).isValidatingFacets(this.readProperties.isValidatingFacets()).build() : callback.receiveReadProperties(this.readProperties, navigationProperty);
                    if (navigationProperty.getMultiplicity() == EdmMultiplicity.MANY) {
                        JsonFeedConsumer inlineConsumer = new JsonFeedConsumer(this.reader, inlineEia, inlineReadProperties);
                        ODataFeed feed = inlineConsumer.readStartedInlineFeed(name);
                        this.updateExpandSelectTree(navigationPropertyName, feed);
                        if (callback == null) {
                            this.properties.put(navigationPropertyName, feed);
                            this.resultEntry.setContainsInlineEntry(true);
                        } else {
                            ReadFeedResult result = new ReadFeedResult(inlineReadProperties, navigationProperty, feed, this.entryMetadata.getId());
                            callback.handleReadFeed(result);
                        }
                    } else {
                        JsonEntryConsumer inlineConsumer = new JsonEntryConsumer(this.reader, inlineEia, inlineReadProperties);
                        ODataEntry entry = inlineConsumer.readInlineEntry(name);
                        this.updateExpandSelectTree(navigationPropertyName, entry);
                        if (callback == null) {
                            this.properties.put(navigationPropertyName, entry);
                            this.resultEntry.setContainsInlineEntry(true);
                        } else {
                            ReadEntryResult result = new ReadEntryResult(inlineReadProperties, navigationProperty, entry, this.entryMetadata.getId());
                            callback.handleReadEntry(result);
                        }
                    }
                }
                catch (ODataApplicationException e) {
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
                }
            }
            this.reader.endObject();
        } else if (peek == JsonToken.NULL) {
            this.reader.nextNull();
        } else {
            EntityProviderReadProperties inlineReadProperties;
            EdmNavigationProperty navigationProperty = (EdmNavigationProperty)this.eia.getEntityType().getProperty(navigationPropertyName);
            EdmEntitySet inlineEntitySet = this.eia.getEntitySet().getRelatedEntitySet(navigationProperty);
            EntityInfoAggregator inlineInfo = EntityInfoAggregator.create(inlineEntitySet);
            OnReadInlineContent callback = this.readProperties.getCallback();
            if (callback == null) {
                inlineReadProperties = EntityProviderReadProperties.init().mergeSemantic(this.readProperties.getMergeSemantic()).isValidatingFacets(this.readProperties.isValidatingFacets()).build();
            } else {
                try {
                    inlineReadProperties = callback.receiveReadProperties(this.readProperties, navigationProperty);
                }
                catch (ODataApplicationException e) {
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
                }
            }
            ODataFeed feed = new JsonFeedConsumer(this.reader, inlineInfo, inlineReadProperties).readInlineFeedStandalone();
            this.updateExpandSelectTree(navigationPropertyName, feed);
            if (callback == null) {
                this.properties.put(navigationPropertyName, feed);
                this.resultEntry.setContainsInlineEntry(true);
            } else {
                ReadFeedResult result = new ReadFeedResult(inlineReadProperties, navigationProperty, feed, this.entryMetadata.getId());
                try {
                    callback.handleReadFeed(result);
                }
                catch (ODataApplicationException e) {
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
                }
            }
        }
    }

    private void updateExpandSelectTree(String navigationPropertyName, ODataFeed feed) {
        List entries = feed.getEntries();
        if (!entries.isEmpty()) {
            this.updateExpandSelectTree(navigationPropertyName, (ODataEntry)entries.get(0));
            for (ODataEntry entry : entries) {
                ExpandSelectTreeNodeImpl newExpandedSelectedTree = new ExpandSelectTreeNodeImpl();
                newExpandedSelectedTree.setExpanded();
                newExpandedSelectedTree.setExplicitlySelected();
                newExpandedSelectedTree.putLink(navigationPropertyName, (ExpandSelectTreeNodeImpl)entry.getExpandSelectTree());
                this.expandSelectTree.getExpandedList().add(newExpandedSelectedTree);
            }
        } else {
            this.expandSelectTree.setExpanded();
            this.expandSelectTree.setExplicitlySelected();
            this.expandSelectTree.putLink(navigationPropertyName, new ExpandSelectTreeNodeImpl());
        }
    }

    private void updateExpandSelectTree(String navigationPropertyName, ODataEntry entry) {
        this.expandSelectTree.setExpanded();
        this.expandSelectTree.setExplicitlySelected();
        this.expandSelectTree.putLink(navigationPropertyName, (ExpandSelectTreeNodeImpl)entry.getExpandSelectTree());
    }

    private ODataEntry readInlineEntry(String name) throws EdmException, EntityProviderException, IOException {
        this.handleName(name);
        this.readEntryContent();
        return this.resultEntry;
    }
}

