/****************************************************************************
 * arch/sim/src/sim/up_x11eventloop.c
 *
 *   Copyright (C) 2011 Gregory Nutt. All rights reserved.
 *   Author: Gregory Nutt <gnutt@nuttx.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name NuttX nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <stdio.h>
#include <X11/Xlib.h>

#include "up_internal.h"

/****************************************************************************
 * Public Data
 ****************************************************************************/

/* Defined in up_x11framebuffer.c */

extern Display *g_display;

/****************************************************************************
 * Private Functions
 ****************************************************************************/

/****************************************************************************
 * Name: up_buttonmap
 ****************************************************************************/

static int up_buttonmap(int state)
{
  int buttons = 0;

  /* Remove any X11 dependencies.  Just maps ButtonNMask to bit N. */

  if ((state & Button1Mask) != 0)
    {
      buttons |= 1;
    }

  if ((state & Button2Mask) != 0)
    {
      buttons |= 2;
    }

  if ((state & Button3Mask) != 0)
    {
      buttons |= 4;
    }

  return buttons;
}

/****************************************************************************
 * Public Functions
 ****************************************************************************/

/****************************************************************************
 * Name: up_x11events
 *
 * Description:
 *   Called periodically from the IDLE loop to check for queued X11 events.
 *
 ****************************************************************************/

void up_x11events(void)
{
  XEvent event;

  /* Check if there are any pending, queue X11 events. */

  if (g_display && XPending(g_display) > 0)
    {
      /* Yes, get the event (this should not block since we know there are
       * pending events)
       */

      XNextEvent(g_display, &event);

      /* Then process the event */

      switch (event.type)
        {
          case MotionNotify : /* Enabled by ButtonMotionMask */
            {
              up_buttonevent(event.xmotion.x, event.xmotion.y,
                             up_buttonmap(event.xmotion.state));
            }
            break;

          case ButtonPress  : /* Enabled by ButtonPressMask */
          case ButtonRelease: /* Enabled by ButtonReleaseMask */
            {
              up_buttonevent(event.xbutton.x, event.xbutton.y,
                             up_buttonmap(event.xbutton.state));
            }
            break;

          default :
            break;
        }
    }
}
