/*
 * Decompiled with CFR 0.152.
 */
package org.epistem.io;

import java.io.IOException;
import java.io.InputStream;

public class SubsetInputStream
extends InputStream {
    protected InputStream in;
    protected int length;
    protected int read;

    public SubsetInputStream(InputStream inputStream, int n) {
        this.in = inputStream;
        this.length = n;
        this.read = 0;
    }

    public int getRead() {
        return this.read;
    }

    public void consume() throws IOException {
        if (this.read < this.length) {
            this.in.skip(this.length - this.read);
        }
        this.read = this.length;
    }

    public void close() throws IOException {
        this.consume();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.read + n2 > this.length) {
            n2 = this.length - this.read;
        }
        if ((n3 = this.in.read(byArray, n, n2)) < 0) {
            this.read = this.length;
            return -1;
        }
        this.read += n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        if (l > (long)(this.length - this.read)) {
            l = this.length - this.read;
        }
        long l2 = this.in.skip(l);
        this.read += (int)l2;
        return l2;
    }

    public int read() throws IOException {
        if (this.read >= this.length) {
            return -1;
        }
        ++this.read;
        return this.in.read();
    }
}

