/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.video;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.video.ScreenVideoImage;
import com.anotherbigidea.flash.video.ScreenVideoImageBlock;
import com.anotherbigidea.flash.video.ScreenVideoPacket;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class ScreenVideoStream {
    private SWFTagTypes timeline;
    private int depth;
    private int streamId;
    private int frameNumber = 0;
    private int blockWidth;
    private int blockHeight;
    private ScreenVideoImageBlock[] imageBlocks;

    public ScreenVideoStream(SWFTagTypes sWFTagTypes) {
        this.timeline = sWFTagTypes;
    }

    public void startStream(int n, int n2, int n3, int n4, ScreenVideoImage screenVideoImage, int n5, int n6, int n7) throws IOException {
        this.depth = n4;
        this.streamId = n3;
        this.timeline.tagDefineVideoStream(n3, n5, screenVideoImage.getImageWidth(), screenVideoImage.getImageHeight(), 0, 3);
        this.timeline.tagPlaceObject2(false, 0, n4, n3, new Matrix(20 * n, 20 * n2), null, -1, null, 0);
        this.keyFrame(screenVideoImage, n6, n7);
    }

    public void interFrame(ScreenVideoImage screenVideoImage) throws IOException {
        ScreenVideoImageBlock[] screenVideoImageBlockArray = screenVideoImage.toBlocks(this.blockWidth, this.blockHeight);
        ScreenVideoImageBlock[] screenVideoImageBlockArray2 = new ScreenVideoImageBlock[screenVideoImageBlockArray.length];
        for (int i = 0; i < screenVideoImageBlockArray2.length; ++i) {
            screenVideoImageBlockArray2[i] = screenVideoImageBlockArray[i].equals(this.imageBlocks[i]) ? ScreenVideoImageBlock.EMPTY_BLOCK : screenVideoImageBlockArray[i];
        }
        this.imageBlocks = screenVideoImageBlockArray;
        ScreenVideoPacket screenVideoPacket = new ScreenVideoPacket(screenVideoImage.getImageWidth(), screenVideoImage.getImageHeight(), this.blockWidth, this.blockHeight, screenVideoImageBlockArray2);
        this.timeline.tagPlaceObject2(true, 0, this.depth, 0, null, null, this.frameNumber, null, 0);
        this.timeline.tagVideoFrame(this.streamId, this.frameNumber++, 2, 3, screenVideoPacket.toBytes());
    }

    public void keyFrame(ScreenVideoImage screenVideoImage, int n, int n2) throws IOException {
        this.blockWidth = n;
        this.blockHeight = n2;
        this.imageBlocks = screenVideoImage.toBlocks(n, n2);
        ScreenVideoPacket screenVideoPacket = new ScreenVideoPacket(screenVideoImage.getImageWidth(), screenVideoImage.getImageHeight(), n, n2, this.imageBlocks);
        this.timeline.tagPlaceObject2(true, 0, this.depth, 0, null, null, this.frameNumber, null, 0);
        this.timeline.tagVideoFrame(this.streamId, this.frameNumber++, 1, 3, screenVideoPacket.toBytes());
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        File file = new File("c:\\temp\\screenshots");
        Object[] objectArray = file.list();
        Arrays.sort(objectArray);
        BufferedImage bufferedImage = ImageIO.read(new File(file, (String)objectArray[0]));
        ScreenVideoImage screenVideoImage = new ScreenVideoImage(bufferedImage, 0, 0, 800, 600);
        SWFWriter sWFWriter = new SWFWriter("c:\\temp\\screenshots.swf");
        TagWriter tagWriter = new TagWriter(sWFWriter);
        sWFWriter.setCompression(true);
        tagWriter.header(7, -1L, screenVideoImage.getImageWidth() * 20, screenVideoImage.getImageHeight() * 20, 1, -1);
        tagWriter.tagSetBackgroundColor(new Color(255, 0, 0));
        ScreenVideoStream screenVideoStream = new ScreenVideoStream(tagWriter);
        screenVideoStream.startStream(0, 0, 1, 1, screenVideoImage, objectArray.length, 64, 64);
        tagWriter.tagShowFrame();
        for (int i = 1; i < objectArray.length; ++i) {
            bufferedImage = ImageIO.read(new File(file, (String)objectArray[i]));
            object = new ScreenVideoImage(bufferedImage, 0, 0, 800, 600);
            System.out.println("Adding image " + (String)objectArray[i]);
            screenVideoStream.interFrame((ScreenVideoImage)object);
            tagWriter.tagShowFrame();
        }
        SWFActions sWFActions = tagWriter.tagDoAction();
        object = sWFActions.start(0);
        object.end();
        sWFActions.done();
        tagWriter.tagShowFrame();
        tagWriter.tagEnd();
        System.out.println("Done");
    }
}

