/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.video;

import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class ScreenVideoImageBlock {
    public static final ScreenVideoImageBlock EMPTY_BLOCK = new ScreenVideoImageBlock(new int[0]);
    private int[] pixelData;

    public ScreenVideoImageBlock(int[] nArray) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        this.pixelData = nArray;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ScreenVideoImageBlock)) {
            return false;
        }
        ScreenVideoImageBlock screenVideoImageBlock = (ScreenVideoImageBlock)object;
        if (this.pixelData.length != screenVideoImageBlock.pixelData.length) {
            return false;
        }
        return Arrays.equals(this.pixelData, screenVideoImageBlock.pixelData);
    }

    public ScreenVideoImageBlock(InStream inStream, int n, int n2) throws IOException {
        int n3 = (int)inStream.readUBits(16);
        if (n3 == 0) {
            this.pixelData = new int[0];
            return;
        }
        byte[] byArray = inStream.read(n3);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        int n4 = n * n2;
        this.pixelData = new int[n4];
        for (int i = 0; i < n4; ++i) {
            int n5 = inflaterInputStream.read();
            if (n5 < 0) {
                throw new IOException("EOF when reading pixel blue");
            }
            int n6 = inflaterInputStream.read();
            if (n6 < 0) {
                throw new IOException("EOF when reading pixel green");
            }
            int n7 = inflaterInputStream.read();
            if (n7 < 0) {
                throw new IOException("EOF when reading pixel red");
            }
            this.pixelData[i] = (n7 << 16) + (n6 << 8) + n5;
        }
        if (inflaterInputStream.read() != -1) {
            throw new IOException("Unexpected data after pixels in ScreenVideoImageBlock");
        }
    }

    public int[] getPixelData() {
        return this.pixelData;
    }

    public void setPixelData(int[] nArray) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        this.pixelData = nArray;
    }

    public void write(OutStream outStream) throws IOException {
        if (this.pixelData == null || this.pixelData.length == 0) {
            outStream.writeUBits(16, 0L);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        for (int i = 0; i < this.pixelData.length; ++i) {
            int n = this.pixelData[i];
            int n2 = n >> 16 & 0xFF;
            int n3 = n >> 8 & 0xFF;
            int n4 = n & 0xFF;
            deflaterOutputStream.write(n4);
            deflaterOutputStream.write(n3);
            deflaterOutputStream.write(n2);
        }
        deflaterOutputStream.finish();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        outStream.writeUBits(16, byArray.length);
        outStream.write(byArray);
    }

    public static ScreenVideoImageBlock makeSquareOfSingleColor(int n, int n2) {
        int[] nArray = new int[n2 * n2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i == 0 ? 0xFFFFFF : n;
        }
        return new ScreenVideoImageBlock(nArray);
    }
}

