/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.sound;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MP3Frame {
    public static final int MPEG_Version_2_5 = 0;
    public static final int MPEG_Version_2 = 2;
    public static final int MPEG_Version_1 = 3;
    public static final int MPEG_Layer_3 = 1;
    public static final int MPEG_Layer_2 = 2;
    public static final int MPEG_Layer_1 = 3;
    public static final int CHANNEL_MODE_STEREO = 0;
    public static final int CHANNEL_MODE_JOINT_STEREO = 1;
    public static final int CHANNEL_MODE_DUAL_CHANNEL = 2;
    public static final int CHANNEL_MODE_MONO = 3;
    public static final int EMPHASIS_NONE = 0;
    public static final int EMPHASIS_50_15_MS = 1;
    public static final int EMPHASIS_RESERVED = 2;
    public static final int EMPHASIS_CCIT_J17 = 3;
    protected static final int[] MPEG1BitRates = new int[]{0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0};
    protected static final int[] MPEG2BitRates = new int[]{0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0};
    protected static final int[] MPEG10SampleRates = new int[]{44100, 48000, 32000, 0};
    protected static final int[] MPEG20SampleRates = new int[]{22050, 24000, 16000, 0};
    protected static final int[] MPEG25SampleRates = new int[]{11025, 12000, 8000, 0};
    private static int FRAME_SAMPLES_MPEG_1 = 1152;
    private static int FRAME_SAMPLES_MPEG_2 = 576;
    protected int mpegVersion;
    protected int mpegLayer;
    protected boolean isProtected;
    protected int bitRate;
    protected int sampleRate;
    protected boolean padded;
    protected int channelMode;
    protected int modeExtension;
    protected boolean copyrighted;
    protected boolean original;
    protected int emphasis;
    protected byte[] data;
    protected int bit_rate;
    protected int sample_rate;

    public int getBitRate() {
        return this.bitRate;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isStereo() {
        return this.channelMode != 3;
    }

    public int getDataLength() {
        return this.data.length;
    }

    public int getSamplesPerFrame() {
        if (this.mpegVersion == 3) {
            return FRAME_SAMPLES_MPEG_1;
        }
        return FRAME_SAMPLES_MPEG_2;
    }

    public static MP3Frame readFrame(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        MP3Frame mP3Frame = new MP3Frame();
        while (true) {
            if ((n3 = inputStream.read()) < 0) {
                return null;
            }
            if (n3 != 255) continue;
            n3 = inputStream.read();
            if (n3 < 0) {
                return null;
            }
            if ((n3 & 0xE0) != 224) continue;
            mP3Frame.mpegVersion = (n3 & 0x18) >> 3;
            mP3Frame.mpegLayer = (n3 & 6) >> 1;
            boolean bl = mP3Frame.isProtected = (n3 & 1) == 0;
            if (mP3Frame.mpegLayer == 1) break;
        }
        if (mP3Frame.isProtected) {
            inputStream.read();
            inputStream.read();
        }
        if ((n3 = inputStream.read()) < 0) {
            return null;
        }
        mP3Frame.bit_rate = (n3 & 0xF0) >> 4;
        mP3Frame.bitRate = mP3Frame.mpegVersion == 3 ? MPEG1BitRates[mP3Frame.bit_rate] : MPEG2BitRates[mP3Frame.bit_rate];
        mP3Frame.sample_rate = (n3 & 0xC) >> 2;
        mP3Frame.sampleRate = mP3Frame.mpegVersion == 3 ? MPEG10SampleRates[mP3Frame.sample_rate] : (mP3Frame.mpegVersion == 2 ? MPEG20SampleRates[mP3Frame.sample_rate] : MPEG25SampleRates[mP3Frame.sample_rate]);
        mP3Frame.padded = (n3 & 2) != 0;
        n3 = inputStream.read();
        if (n3 < 0) {
            return null;
        }
        mP3Frame.channelMode = (n3 & 0xC0) >> 6;
        mP3Frame.modeExtension = (n3 & 0x30) >> 4;
        mP3Frame.copyrighted = (n3 & 0x80) >> 3 != 0;
        mP3Frame.original = (n3 & 0x40) >> 2 != 0;
        mP3Frame.emphasis = n3 & 2;
        int n4 = (mP3Frame.mpegVersion == 3 ? 144 : 72) * mP3Frame.bitRate / mP3Frame.sampleRate + (mP3Frame.padded ? 1 : 0) - 4;
        byte[] byArray = new byte[n4];
        for (n = 0; (n2 = inputStream.read(byArray, n, n4 - n)) >= 0 && n < n4; n += n2) {
        }
        if (n != n4) {
            throw new IOException("Unexpected end of MP3 data");
        }
        mP3Frame.data = byArray;
        return mP3Frame;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(255);
        int n = 225;
        n |= this.mpegVersion << 3;
        outputStream.write(n |= this.mpegLayer << 1);
        n = this.bit_rate << 4;
        n |= this.sample_rate << 2;
        if (this.padded) {
            n |= 2;
        }
        outputStream.write(n);
        n = this.channelMode << 6;
        n |= this.modeExtension << 4;
        outputStream.write(n |= this.emphasis);
        outputStream.write(this.data);
    }

    public String toString() {
        String string = null;
        if (this.mpegVersion == 3) {
            string = "1";
        } else if (this.mpegVersion == 2) {
            string = "2";
        } else if (this.mpegVersion == 0) {
            string = "2.5";
        }
        return "MP3 Frame:  version=" + string + " bit-rate=" + this.bitRate + " sample-rate=" + this.sampleRate + " stereo=" + (this.channelMode != 3);
    }
}

