/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.layertree;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v106.dom.model.Rect;
import org.openqa.selenium.devtools.v106.layertree.model.Layer;
import org.openqa.selenium.devtools.v106.layertree.model.LayerId;
import org.openqa.selenium.devtools.v106.layertree.model.LayerPainted;
import org.openqa.selenium.devtools.v106.layertree.model.PaintProfile;
import org.openqa.selenium.devtools.v106.layertree.model.PictureTile;
import org.openqa.selenium.devtools.v106.layertree.model.SnapshotId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class LayerTree {
    public static Command<CompositingReasonsResponse> compositingReasons(LayerId layerId) {
        Objects.requireNonNull(layerId, "layerId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"layerId", (Object)layerId);
        return new Command("LayerTree.compositingReasons", (Map)params.build(), input -> (CompositingReasonsResponse)input.read(CompositingReasonsResponse.class));
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("LayerTree.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("LayerTree.enable", (Map)params.build());
    }

    public static Command<SnapshotId> loadSnapshot(List<PictureTile> tiles) {
        Objects.requireNonNull(tiles, "tiles is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"tiles", tiles);
        return new Command("LayerTree.loadSnapshot", (Map)params.build(), ConverterFunctions.map((String)"snapshotId", SnapshotId.class));
    }

    public static Command<SnapshotId> makeSnapshot(LayerId layerId) {
        Objects.requireNonNull(layerId, "layerId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"layerId", (Object)layerId);
        return new Command("LayerTree.makeSnapshot", (Map)params.build(), ConverterFunctions.map((String)"snapshotId", SnapshotId.class));
    }

    public static Command<List<PaintProfile>> profileSnapshot(SnapshotId snapshotId, Optional<Integer> minRepeatCount, Optional<Number> minDuration, Optional<Rect> clipRect) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"snapshotId", (Object)snapshotId);
        minRepeatCount.ifPresent(p -> params.put((Object)"minRepeatCount", p));
        minDuration.ifPresent(p -> params.put((Object)"minDuration", p));
        clipRect.ifPresent(p -> params.put((Object)"clipRect", p));
        return new Command("LayerTree.profileSnapshot", (Map)params.build(), ConverterFunctions.map((String)"timings", (Type)new TypeToken<List<PaintProfile>>(){}.getType()));
    }

    public static Command<Void> releaseSnapshot(SnapshotId snapshotId) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"snapshotId", (Object)snapshotId);
        return new Command("LayerTree.releaseSnapshot", (Map)params.build());
    }

    public static Command<String> replaySnapshot(SnapshotId snapshotId, Optional<Integer> fromStep, Optional<Integer> toStep, Optional<Number> scale) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"snapshotId", (Object)snapshotId);
        fromStep.ifPresent(p -> params.put((Object)"fromStep", p));
        toStep.ifPresent(p -> params.put((Object)"toStep", p));
        scale.ifPresent(p -> params.put((Object)"scale", p));
        return new Command("LayerTree.replaySnapshot", (Map)params.build(), ConverterFunctions.map((String)"dataURL", String.class));
    }

    public static Command<List<Map<String, Object>>> snapshotCommandLog(SnapshotId snapshotId) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"snapshotId", (Object)snapshotId);
        return new Command("LayerTree.snapshotCommandLog", (Map)params.build(), ConverterFunctions.map((String)"commandLog", (Type)new TypeToken<List<Map<String, Object>>>(){}.getType()));
    }

    public static Event<LayerPainted> layerPainted() {
        return new Event("LayerTree.layerPainted", input -> (LayerPainted)input.read(LayerPainted.class));
    }

    public static Event<List<Layer>> layerTreeDidChange() {
        return new Event("LayerTree.layerTreeDidChange", ConverterFunctions.map((String)"layers", (Type)new TypeToken<List<Layer>>(){}.getType()));
    }

    public static class CompositingReasonsResponse {
        private final List<String> compositingReasons;
        private final List<String> compositingReasonIds;

        public CompositingReasonsResponse(List<String> compositingReasons, List<String> compositingReasonIds) {
            this.compositingReasons = Objects.requireNonNull(compositingReasons, "compositingReasons is required");
            this.compositingReasonIds = Objects.requireNonNull(compositingReasonIds, "compositingReasonIds is required");
        }

        public List<String> getCompositingReasons() {
            return this.compositingReasons;
        }

        public List<String> getCompositingReasonIds() {
            return this.compositingReasonIds;
        }

        private static CompositingReasonsResponse fromJson(JsonInput input) {
            List compositingReasons = null;
            List compositingReasonIds = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "compositingReasons": {
                        compositingReasons = (List)input.read(new TypeToken<List<String>>(){}.getType());
                        continue block8;
                    }
                    case "compositingReasonIds": {
                        compositingReasonIds = (List)input.read(new TypeToken<List<String>>(){}.getType());
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CompositingReasonsResponse(compositingReasons, compositingReasonIds);
        }
    }
}

