/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;

public class TimingUtil {
    public static DateTimeFormatter logDateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static String logDateMillis(long millis) {
        return logDateFormat.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()));
    }

    public static String elapsedTime(long start, long end) {
        if (start > end) {
            return null;
        }
        return TimingUtil.secondsToHMS((end - start) / 1000L);
    }

    public static String secondsToHMS(long seconds) {
        long hours = TimeUnit.SECONDS.toHours(seconds);
        long minutes = TimeUnit.SECONDS.toMinutes(seconds) % TimeUnit.HOURS.toMinutes(1L);
        seconds = TimeUnit.SECONDS.toSeconds(seconds) % TimeUnit.MINUTES.toSeconds(1L);
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public static String secondsToDaysHMS(long seconds) {
        long days = TimeUnit.SECONDS.toDays(seconds);
        if (days == 0L) {
            return TimingUtil.secondsToHMS(seconds);
        }
        String hhmmss = TimingUtil.secondsToHMS(seconds % TimeUnit.DAYS.toSeconds(1L));
        return String.format("%d days, %s", days, hhmmss);
    }
}

