/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.parse.ParseText;

public class ParseImpl
implements Parse,
Writable {
    private ParseText text;
    private ParseData data;
    private boolean isCanonical;

    public ParseImpl() {
    }

    public ParseImpl(Parse parse) {
        this(new ParseText(parse.getText()), parse.getData(), true);
    }

    public ParseImpl(String text, ParseData data) {
        this(new ParseText(text), data, true);
    }

    public ParseImpl(ParseText text, ParseData data) {
        this(text, data, true);
    }

    public ParseImpl(ParseText text, ParseData data, boolean isCanonical) {
        this.text = text;
        this.data = data;
        this.isCanonical = isCanonical;
    }

    @Override
    public String getText() {
        return this.text.getText();
    }

    @Override
    public ParseData getData() {
        return this.data;
    }

    @Override
    public boolean isCanonical() {
        return this.isCanonical;
    }

    public final void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isCanonical);
        this.text.write(out);
        this.data.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.isCanonical = in.readBoolean();
        this.text = new ParseText();
        this.text.readFields(in);
        this.data = new ParseData();
        this.data.readFields(in);
    }

    public static ParseImpl read(DataInput in) throws IOException {
        ParseImpl parseImpl = new ParseImpl();
        parseImpl.readFields(in);
        return parseImpl;
    }
}

