/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.similarity.cosine;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.scoring.similarity.SimilarityModel;
import org.apache.nutch.scoring.similarity.cosine.DocVector;
import org.apache.nutch.scoring.similarity.cosine.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosineSimilarity
implements SimilarityModel {
    private Configuration conf;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public float setURLScoreAfterParsing(Text url, Content content, Parse parse) {
        float score = 1.0f;
        try {
            if (!Model.isModelCreated) {
                Model.createModel(this.conf);
            }
            String metatags = parse.getData().getParseMeta().get("metatag.keyword");
            String metaDescription = parse.getData().getParseMeta().get("metatag.description");
            int[] ngramArr = Model.retrieveNgrams(this.conf);
            int mingram = ngramArr[0];
            int maxgram = ngramArr[1];
            DocVector docVector = Model.createDocVector(parse.getText() + metaDescription + metatags, mingram, maxgram);
            if (docVector == null) {
                throw new Exception("Could not create DocVector from parsed text");
            }
            score = Model.computeCosineSimilarity(docVector);
            LOG.info("Setting score of {} to {}", (Object)url, (Object)Float.valueOf(score));
        }
        catch (Exception e) {
            LOG.error("Error creating Cosine Model, setting scores of urls to 1 : {}", (Object)StringUtils.stringifyException((Throwable)e));
        }
        return score;
    }

    @Override
    public CrawlDatum distributeScoreToOutlinks(Text fromUrl, ParseData parseData, Collection<Map.Entry<Text, CrawlDatum>> targets, CrawlDatum adjust, int allCount) {
        float score = Float.parseFloat(parseData.getContentMeta().get("nutch.crawl.score"));
        for (Map.Entry<Text, CrawlDatum> target : targets) {
            target.getValue().setScore(score);
        }
        return adjust;
    }
}

