/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.common.Strings;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.AbstractScopedSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.rest.RestRequest;

public final class SettingsFilter {
    public static String SETTINGS_FILTER_PARAM = "settings_filter";
    private final Set<String> patterns;
    private final String patternString;

    public SettingsFilter(Collection<String> patterns) {
        for (String pattern : patterns) {
            if (SettingsFilter.isValidPattern(pattern)) continue;
            throw new IllegalArgumentException("invalid pattern: " + pattern);
        }
        this.patterns = Collections.unmodifiableSet(new HashSet<String>(patterns));
        this.patternString = Strings.collectionToDelimitedString(patterns, ",");
    }

    public Set<String> getPatterns() {
        return this.patterns;
    }

    public static boolean isValidPattern(String pattern) {
        return AbstractScopedSettings.isValidKey(pattern) || Regex.isSimpleMatchPattern(pattern);
    }

    public void addFilterSettingParams(RestRequest request) {
        if (!this.patterns.isEmpty()) {
            request.params().put(SETTINGS_FILTER_PARAM, this.patternString);
        }
    }

    public static Settings filterSettings(ToXContent.Params params, Settings settings) {
        String patterns = params.param(SETTINGS_FILTER_PARAM);
        Settings filteredSettings = patterns != null && !patterns.isEmpty() ? SettingsFilter.filterSettings(Strings.commaDelimitedListToSet(patterns), settings) : settings;
        return filteredSettings;
    }

    public Settings filter(Settings settings) {
        return SettingsFilter.filterSettings(this.patterns, settings);
    }

    private static Settings filterSettings(Iterable<String> patterns, Settings settings) {
        Settings.Builder builder = Settings.builder().put(settings);
        ArrayList<String> simpleMatchPatternList = new ArrayList<String>();
        for (String pattern : patterns) {
            if (Regex.isSimpleMatchPattern(pattern)) {
                simpleMatchPatternList.add(pattern);
                continue;
            }
            builder.remove(pattern);
        }
        if (!simpleMatchPatternList.isEmpty()) {
            String[] simpleMatchPatterns = simpleMatchPatternList.toArray(new String[simpleMatchPatternList.size()]);
            builder.keys().removeIf(key -> Regex.simpleMatch(simpleMatchPatterns, key));
        }
        return builder.build();
    }
}

