/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.okhttp;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Connection;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.brotli.BrotliInterceptor;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.protocol.ProtocolException;
import org.apache.nutch.protocol.http.api.HttpBase;
import org.apache.nutch.protocol.okhttp.IPFilterRules;
import org.apache.nutch.protocol.okhttp.OkHttpResponse;
import org.apache.nutch.util.NutchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttp
extends HttpBase {
    protected static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<String[]> customRequestHeaders = new LinkedList<String[]>();
    private OkHttpClient[] clients;
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};

    public OkHttp() {
        super(LOG);
    }

    public void setConf(Configuration conf) {
        IPFilterRules ipFilterRules;
        super.setConf(conf);
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        if (this.useHttp2) {
            protocols.add(Protocol.HTTP_2);
        }
        protocols.add(Protocol.HTTP_1_1);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().protocols(protocols).retryOnConnectionFailure(true).followRedirects(false).connectTimeout((long)this.timeout, TimeUnit.MILLISECONDS).writeTimeout((long)this.timeout, TimeUnit.MILLISECONDS).readTimeout((long)this.timeout, TimeUnit.MILLISECONDS);
        if (!this.tlsCheckCertificate) {
            try {
                SSLContext trustAllSslContext = SSLContext.getInstance("TLS");
                trustAllSslContext.init(null, trustAllCerts, null);
                SSLSocketFactory trustAllSslSocketFactory = trustAllSslContext.getSocketFactory();
                builder.sslSocketFactory(trustAllSslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            }
            catch (Exception e) {
                LOG.error("Failed to disable TLS certificate verification (property http.tls.certificates.check)", (Throwable)e);
            }
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        if (!this.accept.isEmpty()) {
            this.getCustomRequestHeaders().add(new String[]{"Accept", this.accept});
        }
        if (!this.acceptLanguage.isEmpty()) {
            this.getCustomRequestHeaders().add(new String[]{"Accept-Language", this.acceptLanguage});
        }
        if (!this.acceptCharset.isEmpty()) {
            this.getCustomRequestHeaders().add(new String[]{"Accept-Charset", this.acceptCharset});
        }
        if (this.useProxy) {
            final Proxy proxy = new Proxy(this.proxyType, new InetSocketAddress(this.proxyHost, this.proxyPort));
            final String proxyUsername = conf.get("http.proxy.username");
            if (proxyUsername == null) {
                ProxySelector selector = new ProxySelector(){
                    private final List<Proxy> noProxyList = new ArrayList<Proxy>(){
                        {
                            this.add(Proxy.NO_PROXY);
                        }
                    };
                    private final List<Proxy> proxyList = new ArrayList<Proxy>(){
                        {
                            this.add(proxy);
                        }
                    };

                    @Override
                    public List<Proxy> select(URI uri) {
                        if (OkHttp.this.useProxy(uri)) {
                            return this.proxyList;
                        }
                        return this.noProxyList;
                    }

                    @Override
                    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                        LOG.error("Connection to proxy failed for {}: {}", (Object)uri, (Object)ioe);
                    }
                };
                builder.proxySelector(selector);
            } else {
                if (this.proxyException.size() > 0) {
                    LOG.warn("protocol-okhttp does not respect 'http.proxy.exception.list' setting when 'http.proxy.username' is set. This is a limitation of the current okhttp3 implementation, see NUTCH-2636");
                }
                builder.proxy(proxy);
                final String proxyPassword = conf.get("http.proxy.password");
                Authenticator proxyAuthenticator = new Authenticator(){

                    public Request authenticate(Route route, Response response) throws IOException {
                        String credential = Credentials.basic((String)proxyUsername, (String)proxyPassword);
                        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    }
                };
                builder.proxyAuthenticator(proxyAuthenticator);
            }
        }
        if (!(ipFilterRules = new IPFilterRules(conf)).isEmpty()) {
            builder.addNetworkInterceptor((Interceptor)new HTTPFilterIPAddressInterceptor(ipFilterRules));
        }
        if (this.storeIPAddress || this.storeHttpHeaders || this.storeHttpRequest) {
            builder.addNetworkInterceptor((Interceptor)new HTTPHeadersInterceptor());
        }
        builder.addInterceptor((Interceptor)BrotliInterceptor.INSTANCE);
        int numConnectionPools = 1;
        Supplier<ConnectionPool> poolSupplier = null;
        if (!conf.get("http.connection.pool.okhttp", "").isEmpty()) {
            int[] poolConfig = new int[]{};
            try {
                poolConfig = conf.getInts("http.connection.pool.okhttp");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (poolConfig.length == 3 && poolConfig[0] > 0 && poolConfig[1] > 0 && poolConfig[2] > 0) {
                numConnectionPools = poolConfig[0];
                int size = poolConfig[1];
                int time = poolConfig[2];
                poolSupplier = () -> new ConnectionPool(size, (long)time, TimeUnit.SECONDS);
                LOG.info("Using {} connection pool{} with max. {} idle connections and {} sec. connection keep-alive time", new Object[]{poolConfig[0], poolConfig[0] > 1 ? "s" : "", poolConfig[1], poolConfig[2]});
            } else {
                LOG.warn("Ignoring invalid connection pool configuration 'http.connection.pool.okhttp': '{}'", (Object)conf.get("http.connection.pool.okhttp"));
            }
        }
        if (poolSupplier == null) {
            poolSupplier = ConnectionPool::new;
            LOG.info("Using single connection pool with default settings");
        }
        this.clients = new OkHttpClient[numConnectionPools];
        for (int i = 0; i < numConnectionPools; ++i) {
            this.clients[i] = builder.connectionPool(poolSupplier.get()).build();
        }
    }

    protected List<String[]> getCustomRequestHeaders() {
        return this.customRequestHeaders;
    }

    protected OkHttpClient getClient(URL url) {
        if (this.clients.length == 1) {
            return this.clients[0];
        }
        int hash = url.getHost().hashCode();
        return this.clients[(hash & Integer.MAX_VALUE) % this.clients.length];
    }

    protected org.apache.nutch.net.protocols.Response getResponse(URL url, CrawlDatum datum, boolean redirect) throws ProtocolException, IOException {
        return new OkHttpResponse(this, url, datum);
    }

    public static void main(String[] args) throws Exception {
        OkHttp okhttp = new OkHttp();
        okhttp.setConf(NutchConfiguration.create());
        OkHttp.main((HttpBase)okhttp, (String[])args);
    }

    class HTTPHeadersInterceptor
    implements Interceptor {
        HTTPHeadersInterceptor() {
        }

        private String getNormalizedProtocolName(Protocol protocol) {
            String name = protocol.toString().toUpperCase(Locale.ROOT);
            if ("H2".equals(name)) {
                name = "HTTP/2";
            }
            return name;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Connection connection = chain.connection();
            String ipAddress = null;
            if (OkHttp.this.storeIPAddress) {
                InetAddress address = connection.socket().getInetAddress();
                ipAddress = address.getHostAddress();
            }
            Request request = chain.request();
            Response response = chain.proceed(request);
            StringBuilder requestverbatim = null;
            StringBuilder responseverbatim = null;
            if (OkHttp.this.storeHttpRequest) {
                requestverbatim = new StringBuilder();
                requestverbatim.append(request.method()).append(' ');
                requestverbatim.append(request.url().encodedPath());
                String query = request.url().encodedQuery();
                if (query != null) {
                    requestverbatim.append('?').append(query);
                }
                requestverbatim.append(' ').append(this.getNormalizedProtocolName(connection.protocol())).append("\r\n");
                Headers headers = request.headers();
                int size = headers.size();
                for (int i = 0; i < size; ++i) {
                    String key = headers.name(i);
                    String value = headers.value(i);
                    requestverbatim.append(key).append(": ").append(value).append("\r\n");
                }
                requestverbatim.append("\r\n");
            }
            if (OkHttp.this.storeHttpHeaders) {
                responseverbatim = new StringBuilder();
                responseverbatim.append(this.getNormalizedProtocolName(response.protocol())).append(' ').append(response.code()).append(' ').append(response.message()).append("\r\n");
                Headers headers = response.headers();
                int size = headers.size();
                for (int i = 0; i < size; ++i) {
                    String key = headers.name(i);
                    String value = headers.value(i);
                    responseverbatim.append(key).append(": ").append(value).append("\r\n");
                }
                responseverbatim.append("\r\n");
            }
            Response.Builder builder = response.newBuilder();
            if (ipAddress != null) {
                builder = builder.header("_ip_", ipAddress);
            }
            if (requestverbatim != null) {
                byte[] encodedBytesRequest = Base64.getEncoder().encode(requestverbatim.toString().getBytes());
                builder = builder.header("_request_", new String(encodedBytesRequest));
            }
            if (responseverbatim != null) {
                byte[] encodedBytesResponse = Base64.getEncoder().encode(responseverbatim.toString().getBytes());
                builder = builder.header("_response.headers_", new String(encodedBytesResponse));
            }
            return builder.build();
        }
    }

    class HTTPFilterIPAddressInterceptor
    implements Interceptor {
        IPFilterRules rules;

        public HTTPFilterIPAddressInterceptor(IPFilterRules rules) {
            this.rules = rules;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Connection connection = chain.connection();
            InetAddress address = connection.socket().getInetAddress();
            boolean accept = this.rules.accept(address);
            Request request = chain.request();
            if (accept) {
                return chain.proceed(request);
            }
            LOG.warn("Blocked connection to IP address {}: {}", (Object)address.getHostAddress(), (Object)request.url());
            throw new IOException("Forbidden connection to IP address " + address.getHostAddress());
        }
    }
}

