/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.okhttp;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;

public class CIDR {
    InetAddress addr;
    int mask;

    public CIDR(InetAddress address, int mask) {
        this.addr = address;
        this.mask = mask;
    }

    public CIDR(String cidr) throws IllegalArgumentException {
        String ipStr = cidr;
        int sep = cidr.indexOf(47);
        if (sep > -1) {
            ipStr = cidr.substring(0, sep);
        }
        this.addr = InetAddresses.forString((String)ipStr);
        this.mask = sep > -1 ? Integer.parseInt(cidr.substring(sep + 1)) : this.addr.getAddress().length * 8;
        if (cidr.indexOf(58) > -1 && this.addr.getAddress().length == 4) {
            this.mask = Math.max(0, this.mask - 96);
        }
    }

    public boolean contains(InetAddress address) {
        byte[] addr1;
        byte[] addr0 = this.addr.getAddress();
        if (addr0.length != (addr1 = address.getAddress()).length) {
            return false;
        }
        for (int i = 0; i < addr0.length; ++i) {
            int remainingMaskBits = this.mask - i * 8;
            if (remainingMaskBits <= 0) {
                return true;
            }
            int m = ~(255 >> remainingMaskBits);
            if ((addr0[i] & m) == (addr1[i] & m)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.addr + "/" + this.mask;
    }
}

