/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.httpclient;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.protocol.httpclient.HttpAuthentication;
import org.apache.nutch.protocol.httpclient.HttpAuthenticationException;
import org.apache.nutch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBasicAuthentication
implements HttpAuthentication,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Pattern basic = Pattern.compile("[bB][aA][sS][iI][cC] [rR][eE][aA][lL][mM]=\"(\\w*)\"");
    private static Map<String, HttpBasicAuthentication> authMap = new TreeMap<String, HttpBasicAuthentication>();
    private Configuration conf = null;
    private String challenge = null;
    private ArrayList<String> credentials = null;
    private String realm = null;

    protected HttpBasicAuthentication(String challenge, Configuration conf) throws HttpAuthenticationException {
        this.setConf(conf);
        this.challenge = challenge;
        this.credentials = new ArrayList();
        String username = this.conf.get("http.auth.basic." + challenge + ".user");
        String password = this.conf.get("http.auth.basic." + challenge + ".password");
        if (LOG.isTraceEnabled()) {
            LOG.trace("BasicAuthentication challenge is {}", (Object)challenge);
            LOG.trace("BasicAuthentication username={}", (Object)username);
            LOG.trace("BasicAuthentication password={} (masked)", (Object)StringUtil.mask((String)password));
        }
        if (username == null) {
            throw new HttpAuthenticationException("Username for " + challenge + " is null");
        }
        if (password == null) {
            throw new HttpAuthenticationException("Password for " + challenge + " is null");
        }
        byte[] credBytes = (username + ":" + password).getBytes();
        this.credentials.add("Authorization: Basic " + new String(Base64.encodeBase64((byte[])credBytes)));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Basic credentials: " + this.credentials);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public List<String> getCredentials() {
        return this.credentials;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public static HttpBasicAuthentication getAuthentication(String challenge, Configuration conf) {
        if (challenge == null) {
            return null;
        }
        Matcher basicMatcher = basic.matcher(challenge);
        if (basicMatcher.matches()) {
            String realm = basicMatcher.group(1);
            HttpBasicAuthentication auth = authMap.get(realm);
            if (auth == null) {
                HttpBasicAuthentication newAuth;
                block5: {
                    newAuth = null;
                    try {
                        newAuth = new HttpBasicAuthentication(realm, conf);
                    }
                    catch (HttpAuthenticationException hae) {
                        if (!LOG.isTraceEnabled()) break block5;
                        LOG.trace("HttpBasicAuthentication failed for " + challenge);
                    }
                }
                authMap.put(realm, newAuth);
                return newAuth;
            }
            return auth;
        }
        return null;
    }

    public static final Pattern getBasicPattern() {
        return basic;
    }
}

