/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.net.protocols.Response;
import org.apache.nutch.protocol.ProtocolException;
import org.apache.nutch.protocol.http.api.HttpBase;
import org.apache.nutch.protocol.httpclient.DummySSLProtocolSocketFactory;
import org.apache.nutch.protocol.httpclient.HttpFormAuthConfigurer;
import org.apache.nutch.protocol.httpclient.HttpFormAuthentication;
import org.apache.nutch.protocol.httpclient.HttpResponse;
import org.apache.nutch.util.NutchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Http
extends HttpBase {
    protected static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private static HttpClient client = new HttpClient((HttpConnectionManager)connectionManager);
    private static String defaultUsername;
    private static String defaultPassword;
    private static String defaultRealm;
    private static String defaultScheme;
    private static String authFile;
    private static String agentHost;
    private static boolean authRulesRead;
    private static Configuration conf;
    private int maxThreadsTotal = 10;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyRealm;
    private static HttpFormAuthConfigurer formConfigurer;

    static synchronized HttpClient getClient() {
        return client;
    }

    public Http() {
        super(LOG);
    }

    public void setConf(Configuration conf) {
        block2: {
            super.setConf(conf);
            Http.conf = conf;
            this.maxThreadsTotal = conf.getInt("fetcher.threads.fetch", 10);
            this.proxyUsername = conf.get("http.proxy.username", "");
            this.proxyPassword = conf.get("http.proxy.password", "");
            this.proxyRealm = conf.get("http.proxy.realm", "");
            agentHost = conf.get("http.agent.host", "");
            authFile = conf.get("http.auth.file", "");
            this.configureClient();
            try {
                Http.setCredentials();
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Http ", (Throwable)ex);
                LOG.error("Could not read " + authFile + " : " + ex.getMessage());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Http http = new Http();
        http.setConf(NutchConfiguration.create());
        Http.main((HttpBase)http, (String[])args);
    }

    protected Response getResponse(URL url, CrawlDatum datum, boolean redirect) throws ProtocolException, IOException {
        this.resolveCredentials(url);
        return new HttpResponse(this, url, datum, redirect);
    }

    private void configureClient() {
        Object factory = this.tlsCheckCertificate ? new SSLProtocolSocketFactory() : new DummySSLProtocolSocketFactory();
        Protocol https = new Protocol("https", (ProtocolSocketFactory)factory, 443);
        Protocol.registerProtocol((String)"https", (Protocol)https);
        HttpConnectionManagerParams params = connectionManager.getParams();
        params.setConnectionTimeout(this.timeout);
        params.setSoTimeout(this.timeout);
        params.setSendBufferSize(8192);
        params.setReceiveBufferSize(8192);
        params.setMaxTotalConnections(conf.getInt("mapreduce.tasktracker.map.tasks.maximum", 5) * conf.getInt("fetcher.threads.fetch", this.maxThreadsTotal));
        params.setDefaultMaxConnectionsPerHost(conf.getInt("fetcher.threads.fetch", this.maxThreadsTotal));
        client.getParams().setConnectionManagerTimeout((long)this.timeout);
        HostConfiguration hostConf = client.getHostConfiguration();
        ArrayList<Header> headers = new ArrayList<Header>();
        if (!this.acceptLanguage.isEmpty()) {
            headers.add(new Header("Accept-Language", this.acceptLanguage));
        }
        if (!this.acceptCharset.isEmpty()) {
            headers.add(new Header("Accept-Charset", this.acceptCharset));
        }
        if (!this.accept.isEmpty()) {
            headers.add(new Header("Accept", this.accept));
        }
        headers.add(new Header("Accept-Encoding", "x-gzip, gzip, deflate"));
        hostConf.getParams().setParameter("http.default-headers", headers);
        if (this.useProxy) {
            hostConf.setProxy(this.proxyHost, this.proxyPort);
            if (this.proxyUsername.length() > 0) {
                AuthScope proxyAuthScope = Http.getAuthScope(this.proxyHost, this.proxyPort, this.proxyRealm);
                NTCredentials proxyCredentials = new NTCredentials(this.proxyUsername, this.proxyPassword, agentHost, this.proxyRealm);
                client.getState().setProxyCredentials(proxyAuthScope, (Credentials)proxyCredentials);
            }
        }
    }

    private static synchronized void setCredentials() throws ParserConfigurationException, SAXException, IOException {
        if (authRulesRead) {
            return;
        }
        authRulesRead = true;
        InputStream is = conf.getConfResourceAsInputStream(authFile);
        if (is != null) {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            Element rootElement = doc.getDocumentElement();
            if (!"auth-configuration".equals(rootElement.getTagName()) && LOG.isWarnEnabled()) {
                LOG.warn("Bad auth conf file: root element <" + rootElement.getTagName() + "> found in " + authFile + " - must be <auth-configuration>");
            }
            NodeList credList = rootElement.getChildNodes();
            for (int i = 0; i < credList.getLength(); ++i) {
                Node credNode = credList.item(i);
                if (!(credNode instanceof Element)) continue;
                Element credElement = (Element)credNode;
                if (!"credentials".equals(credElement.getTagName())) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("Bad auth conf file: Element <" + credElement.getTagName() + "> not recognized in " + authFile + " - expected <credentials>");
                    continue;
                }
                String authMethod = credElement.getAttribute("authMethod");
                if (StringUtils.isNotBlank((String)authMethod)) {
                    formConfigurer = Http.readFormAuthConfigurer(credElement, authMethod);
                    continue;
                }
                String username = credElement.getAttribute("username");
                String password = credElement.getAttribute("password");
                NodeList scopeList = credElement.getChildNodes();
                for (int j = 0; j < scopeList.getLength(); ++j) {
                    Node scopeNode = scopeList.item(j);
                    if (!(scopeNode instanceof Element)) continue;
                    Element scopeElement = (Element)scopeNode;
                    if ("default".equals(scopeElement.getTagName())) {
                        String realm = scopeElement.getAttribute("realm");
                        String scheme = scopeElement.getAttribute("scheme");
                        defaultUsername = username;
                        defaultPassword = password;
                        defaultRealm = realm;
                        defaultScheme = scheme;
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace("Credentials - username: " + username + "; set as default for realm: " + realm + "; scheme: " + scheme);
                        continue;
                    }
                    if ("authscope".equals(scopeElement.getTagName())) {
                        String host = scopeElement.getAttribute("host");
                        int port = -1;
                        try {
                            port = Integer.parseInt(scopeElement.getAttribute("port"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String realm = scopeElement.getAttribute("realm");
                        String scheme = scopeElement.getAttribute("scheme");
                        AuthScope authScope = Http.getAuthScope(host, port, realm, scheme);
                        NTCredentials credentials = new NTCredentials(username, password, agentHost, realm);
                        client.getState().setCredentials(authScope, (Credentials)credentials);
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace("Credentials - username: " + username + "; set for AuthScope - host: " + host + "; port: " + port + "; realm: " + realm + "; scheme: " + scheme);
                        continue;
                    }
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("Bad auth conf file: Element <" + scopeElement.getTagName() + "> not recognized in " + authFile + " - expected <authscope>");
                }
                is.close();
            }
        }
    }

    private static HttpFormAuthConfigurer readFormAuthConfigurer(Element credElement, String authMethod) {
        if ("formAuth".equals(authMethod)) {
            HttpFormAuthConfigurer formConfigurer = new HttpFormAuthConfigurer();
            String str = credElement.getAttribute("loginUrl");
            if (!StringUtils.isNotBlank((String)str)) {
                throw new IllegalArgumentException("Must set loginUrl.");
            }
            formConfigurer.setLoginUrl(str.trim());
            str = credElement.getAttribute("loginFormId");
            if (!StringUtils.isNotBlank((String)str)) {
                throw new IllegalArgumentException("Must set loginFormId.");
            }
            formConfigurer.setLoginFormId(str.trim());
            str = credElement.getAttribute("loginRedirect");
            if (StringUtils.isNotBlank((String)str)) {
                formConfigurer.setLoginRedirect(Boolean.parseBoolean(str));
            }
            NodeList nodeList = credElement.getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                String value;
                String name;
                Element fieldElement;
                Node fieldNode;
                int k;
                Node node = nodeList.item(j);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                if ("loginPostData".equals(element.getTagName())) {
                    HashMap<String, String> loginPostData = new HashMap<String, String>();
                    NodeList childNodes = element.getChildNodes();
                    for (k = 0; k < childNodes.getLength(); ++k) {
                        fieldNode = childNodes.item(k);
                        if (!(fieldNode instanceof Element)) continue;
                        fieldElement = (Element)fieldNode;
                        name = fieldElement.getAttribute("name");
                        value = fieldElement.getAttribute("value");
                        loginPostData.put(name, value);
                    }
                    formConfigurer.setLoginPostData(loginPostData);
                    continue;
                }
                if ("additionalPostHeaders".equals(element.getTagName())) {
                    HashMap<String, String> additionalPostHeaders = new HashMap<String, String>();
                    NodeList childNodes = element.getChildNodes();
                    for (k = 0; k < childNodes.getLength(); ++k) {
                        fieldNode = childNodes.item(k);
                        if (!(fieldNode instanceof Element)) continue;
                        fieldElement = (Element)fieldNode;
                        name = fieldElement.getAttribute("name");
                        value = fieldElement.getAttribute("value");
                        additionalPostHeaders.put(name, value);
                    }
                    formConfigurer.setAdditionalPostHeaders(additionalPostHeaders);
                    continue;
                }
                if ("removedFormFields".equals(element.getTagName())) {
                    HashSet<String> removedFormFields = new HashSet<String>();
                    NodeList childNodes = element.getChildNodes();
                    for (k = 0; k < childNodes.getLength(); ++k) {
                        fieldNode = childNodes.item(k);
                        if (!(fieldNode instanceof Element)) continue;
                        fieldElement = (Element)fieldNode;
                        name = fieldElement.getAttribute("name");
                        removedFormFields.add(name);
                    }
                    formConfigurer.setRemovedFormFields(removedFormFields);
                    continue;
                }
                if (!"loginCookie".equals(element.getTagName())) continue;
                LOG.debug("start loginCookie");
                NodeList childNodes = element.getChildNodes();
                for (int k2 = 0; k2 < childNodes.getLength(); ++k2) {
                    Element fieldElement2;
                    Node fieldNode2 = childNodes.item(k2);
                    if (!(fieldNode2 instanceof Element) || !"policy".equals((fieldElement2 = (Element)fieldNode2).getTagName())) continue;
                    String policy = fieldElement2.getTextContent();
                    formConfigurer.setCookiePolicy(policy);
                    LOG.debug("cookie policy is " + policy);
                }
            }
            return formConfigurer;
        }
        throw new IllegalArgumentException("Unsupported authMethod: " + authMethod);
    }

    private void resolveCredentials(URL url) {
        if (formConfigurer != null) {
            HttpFormAuthentication formAuther = new HttpFormAuthentication(formConfigurer, client, this);
            try {
                formAuther.login();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (defaultUsername != null && defaultUsername.length() > 0) {
            int port = url.getPort();
            if (port == -1) {
                port = "https".equals(url.getProtocol()) ? 443 : 80;
            }
            AuthScope scope = new AuthScope(url.getHost(), port);
            if (client.getState().getCredentials(scope) != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Pre-configured credentials with scope - host: " + url.getHost() + "; port: " + port + "; found for url: " + url);
                }
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Pre-configured credentials with scope -  host: " + url.getHost() + "; port: " + port + "; not found for url: " + url);
            }
            AuthScope serverAuthScope = Http.getAuthScope(url.getHost(), port, defaultRealm, defaultScheme);
            NTCredentials serverCredentials = new NTCredentials(defaultUsername, defaultPassword, agentHost, defaultRealm);
            client.getState().setCredentials(serverAuthScope, (Credentials)serverCredentials);
        }
    }

    private static AuthScope getAuthScope(String host, int port, String realm, String scheme) {
        if (host.length() == 0) {
            host = null;
        }
        if (port < 0) {
            port = -1;
        }
        if (realm.length() == 0) {
            realm = null;
        }
        if (scheme.length() == 0) {
            scheme = null;
        }
        return new AuthScope(host, port, realm, scheme);
    }

    private static AuthScope getAuthScope(String host, int port, String realm) {
        return Http.getAuthScope(host, port, realm, "");
    }

    static {
        authRulesRead = false;
    }
}

