/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.urlfilter.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLFilter;
import org.apache.nutch.urlfilter.api.RegexRule;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RegexURLFilterBase
implements URLFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<RegexRule> rules;
    private Configuration conf;
    protected boolean hasHostDomainRules = false;

    public RegexURLFilterBase() {
    }

    public RegexURLFilterBase(File filename) throws IOException, IllegalArgumentException {
        this(new FileReader(filename));
    }

    public RegexURLFilterBase(String rules) throws IOException, IllegalArgumentException {
        this(new StringReader(rules));
    }

    protected RegexURLFilterBase(Reader reader) throws IOException, IllegalArgumentException {
        this.rules = this.readRules(reader);
    }

    protected abstract RegexRule createRule(boolean var1, String var2);

    protected abstract RegexRule createRule(boolean var1, String var2, String var3);

    protected abstract Reader getRulesReader(Configuration var1) throws IOException;

    public String filter(String url) {
        String host = null;
        String domain = null;
        if (this.hasHostDomainRules) {
            host = URLUtil.getHost((String)url);
            try {
                domain = URLUtil.getDomainName((String)url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            LOG.debug("URL belongs to host {} and domain {}", (Object)host, (Object)domain);
        }
        for (RegexRule rule : this.rules) {
            if (rule.hostOrDomain() != null && !rule.hostOrDomain().equals(host) && !rule.hostOrDomain().equals(domain)) {
                LOG.debug("Skipping rule [{}] for host: {}", (Object)rule.regex(), (Object)rule.hostOrDomain());
                continue;
            }
            LOG.debug("Applying rule [{}] for host {} and domain {}", new Object[]{rule.regex(), host, domain});
            if (!rule.match(url)) continue;
            return rule.accept() ? url : null;
        }
        return null;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        Reader reader = null;
        try {
            reader = this.getRulesReader(conf);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e.getMessage());
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            this.rules = this.readRules(reader);
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e.getMessage());
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    private List<RegexRule> readRules(Reader reader) throws IOException, IllegalArgumentException {
        String line;
        BufferedReader in = new BufferedReader(reader);
        ArrayList<RegexRule> rules = new ArrayList<RegexRule>();
        String hostOrDomain = null;
        block7: while ((line = in.readLine()) != null) {
            if (line.length() == 0) continue;
            char first = line.charAt(0);
            boolean sign = false;
            switch (first) {
                case '+': {
                    sign = true;
                    break;
                }
                case '-': {
                    sign = false;
                    break;
                }
                case '\n': 
                case ' ': 
                case '#': {
                    continue block7;
                }
                case '>': {
                    hostOrDomain = line.substring(1).trim();
                    this.hasHostDomainRules = true;
                    continue block7;
                }
                case '<': {
                    hostOrDomain = null;
                    continue block7;
                }
                default: {
                    throw new IOException("Invalid first character: " + line);
                }
            }
            String regex = line.substring(1);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Adding rule [" + regex + "] for " + hostOrDomain);
            }
            RegexRule rule = this.createRule(sign, regex, hostOrDomain);
            rules.add(rule);
        }
        return rules;
    }

    public static void main(RegexURLFilterBase filter, String[] args) throws IOException, IllegalArgumentException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = in.readLine()) != null) {
            String out = filter.filter(line);
            if (out != null) {
                System.out.print("+");
                System.out.println(out);
                continue;
            }
            System.out.print("-");
            System.out.println(line);
        }
    }
}

