/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.nutch.indexer.IndexWriter;
import org.apache.nutch.indexer.IndexWriterParams;
import org.apache.nutch.indexer.NutchDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaIndexWriter
implements IndexWriter {
    public static Logger LOG = LoggerFactory.getLogger(KafkaIndexWriter.class);
    private Producer<String, JsonNode> producer;
    private ProducerRecord<String, JsonNode> data;
    private Configuration config;
    private int port = -1;
    private String host = null;
    private String valueSerializer = null;
    private String keySerializer = null;
    private String topic = null;
    private int maxDocCount = -1;
    private String jsonString = null;
    private JsonNode json = null;
    private List<ProducerRecord<String, JsonNode>> inputDocs = null;

    public void open(Configuration job, String name) throws IOException {
    }

    public void open(IndexWriterParams params) throws IOException {
        this.host = (String)params.get((Object)"host");
        this.port = params.getInt("port", 9092);
        this.keySerializer = params.get("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.valueSerializer = params.get("value.serializer", "org.apache.kafka.connect.json.JsonSerializer");
        this.topic = (String)params.get((Object)"topic");
        this.maxDocCount = params.getInt("max.doc.count", 100);
        this.inputDocs = new ArrayList<ProducerRecord<String, JsonNode>>(this.maxDocCount);
        if (StringUtils.isBlank((String)this.host)) {
            Object message = "Missing host. It should be set in index-writers.xml";
            message = (String)message + "\n" + this.describe();
            LOG.error((String)message);
            throw new RuntimeException((String)message);
        }
        Properties configProperties = new Properties();
        configProperties.put("bootstrap.servers", this.host + ":" + this.port);
        configProperties.put("key.serializer", this.keySerializer);
        configProperties.put("value.serializer", this.valueSerializer);
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.producer = new KafkaProducer(configProperties);
    }

    public void write(NutchDocument doc) throws IOException {
        HashMap<String, String[]> source = new HashMap<String, String[]>();
        for (String fieldName : doc.getFieldNames()) {
            HashSet<String> allFieldValues = new HashSet<String>();
            for (Object value : doc.getField(fieldName).getValues()) {
                allFieldValues.add(value.toString());
            }
            String[] fieldValues = allFieldValues.toArray(new String[allFieldValues.size()]);
            source.put(fieldName, fieldValues);
        }
        try {
            this.jsonString = new ObjectMapper().writeValueAsString(source);
            this.json = new ObjectMapper().readTree(this.jsonString);
            this.data = new ProducerRecord(this.topic, (Object)this.json);
            this.inputDocs.add(this.data);
            if (this.inputDocs.size() == this.maxDocCount) {
                this.commit();
            }
        }
        catch (NullPointerException e) {
            LOG.info("Data is empty, all messages have been sent");
        }
    }

    public void delete(String key) throws IOException {
    }

    public void update(NutchDocument doc) throws IOException {
        try {
            this.write(doc);
        }
        catch (IOException e) {
            LOG.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    public void commit() throws IOException {
        try {
            for (ProducerRecord<String, JsonNode> datum : this.inputDocs) {
                this.producer.send(datum);
            }
            this.inputDocs.clear();
        }
        catch (NullPointerException e) {
            LOG.info("All records have been sent to Kakfa on topic {}", (Object)this.topic);
        }
    }

    public void close() throws IOException {
        this.commit();
        this.producer.close();
    }

    public Map<String, Map.Entry<String, Object>> describe() {
        LinkedHashMap<String, Map.Entry<String, Object>> properties = new LinkedHashMap<String, Map.Entry<String, Object>>();
        properties.put("host", new AbstractMap.SimpleEntry<String, String>("Location of the host Kafka cluster to connect to using producerConfig", this.host));
        properties.put("port", new AbstractMap.SimpleEntry<String, Integer>("The port to connect to using the producerConfig", this.port));
        properties.put("topic", new AbstractMap.SimpleEntry<String, String>("Default index to attach to documents", this.topic));
        properties.put("key.serializer", new AbstractMap.SimpleEntry<String, String>("instruct how to turn the key object the user provides with their ProducerRecord into bytes", this.keySerializer));
        properties.put("value.serializer", new AbstractMap.SimpleEntry<String, String>("instruct how to turn the value object the user provides with their ProducerRecord into bytes", this.valueSerializer));
        properties.put("max.doc.count", new AbstractMap.SimpleEntry<String, Integer>("Maximum number of documents before a commit is forced", this.maxDocCount));
        return properties;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    public Configuration getConf() {
        return this.config;
    }
}

