/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse.tika;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.nutch.parse.HTMLMetaTags;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLMetaProcessor {
    public static final void getMetaTags(HTMLMetaTags metaTags, Node node, URL currURL) {
        metaTags.reset();
        HTMLMetaProcessor.getMetaTagsHelper(metaTags, node, currURL);
    }

    private static final void getMetaTagsHelper(HTMLMetaTags metaTags, Node node, URL currURL) {
        NodeList children;
        if (node.getNodeType() == 1) {
            Node hrefNode;
            NamedNodeMap attrs;
            if ("body".equalsIgnoreCase(node.getNodeName())) {
                return;
            }
            if ("meta".equalsIgnoreCase(node.getNodeName())) {
                String content;
                attrs = node.getAttributes();
                Node nameNode = null;
                Node equivNode = null;
                Node contentNode = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    String attrName = attr.getNodeName().toLowerCase(Locale.ROOT);
                    if (attrName.equals("name")) {
                        nameNode = attr;
                        continue;
                    }
                    if (attrName.equals("http-equiv")) {
                        equivNode = attr;
                        continue;
                    }
                    if (!attrName.equals("content")) continue;
                    contentNode = attr;
                }
                if (nameNode != null && contentNode != null) {
                    String name = nameNode.getNodeValue().toLowerCase(Locale.ROOT);
                    metaTags.getGeneralTags().add(name, contentNode.getNodeValue());
                    if ("robots".equals(name)) {
                        String directives = contentNode.getNodeValue().toLowerCase(Locale.ROOT);
                        int index = directives.indexOf("none");
                        if (index >= 0) {
                            metaTags.setNoIndex();
                            metaTags.setNoFollow();
                        }
                        if ((index = directives.indexOf("all")) >= 0) {
                            // empty if block
                        }
                        if ((index = directives.indexOf("noindex")) >= 0) {
                            metaTags.setNoIndex();
                        }
                        if ((index = directives.indexOf("nofollow")) >= 0) {
                            metaTags.setNoFollow();
                        }
                        if ((index = directives.indexOf("noarchive")) >= 0) {
                            metaTags.setNoCache();
                        }
                    } else if (name.equals("pragma")) {
                        content = contentNode.getNodeValue().toLowerCase(Locale.ROOT);
                        if (content.contains("no-cache")) {
                            metaTags.setNoCache();
                        }
                    } else if (name.equals("refresh")) {
                        content = contentNode.getNodeValue().toLowerCase(Locale.ROOT);
                        HTMLMetaProcessor.setRefresh(metaTags, content, currURL);
                    } else if (name.equals("content-location")) {
                        String urlString = contentNode.getNodeValue();
                        URL url = null;
                        try {
                            url = currURL == null ? new URL(urlString) : new URL(currURL, urlString);
                            metaTags.setBaseHref(url);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                }
                if (equivNode != null && contentNode != null) {
                    String name = equivNode.getNodeValue().toLowerCase(Locale.ROOT);
                    content = contentNode.getNodeValue();
                    metaTags.getHttpEquivTags().setProperty(name, content);
                    if ("pragma".equals(name)) {
                        int index = (content = content.toLowerCase(Locale.ROOT)).indexOf("no-cache");
                        if (index >= 0) {
                            metaTags.setNoCache();
                        }
                    } else if ("refresh".equals(name)) {
                        HTMLMetaProcessor.setRefresh(metaTags, content, currURL);
                    }
                }
            } else if ("base".equalsIgnoreCase(node.getNodeName()) && (hrefNode = (attrs = node.getAttributes()).getNamedItem("href")) != null) {
                String urlString = hrefNode.getNodeValue();
                URL url = null;
                try {
                    url = currURL == null ? new URL(urlString) : new URL(currURL, urlString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (url != null) {
                    metaTags.setBaseHref(url);
                }
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                HTMLMetaProcessor.getMetaTagsHelper(metaTags, children.item(i), currURL);
            }
        }
    }

    private static void setRefresh(HTMLMetaTags metaTags, String content, URL currURL) {
        int idx = content.indexOf(59);
        String time = null;
        time = idx == -1 ? content : content.substring(0, idx);
        try {
            metaTags.setRefreshTime(Integer.parseInt(time));
            metaTags.setRefresh(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        URL refreshUrl = null;
        if (metaTags.getRefresh() && idx != -1) {
            idx = content.toLowerCase(Locale.ROOT).indexOf("url=");
            idx = idx == -1 ? content.indexOf(59) + 1 : (idx += 4);
            if (idx != -1) {
                String url = content.substring(idx);
                try {
                    refreshUrl = new URL(url);
                }
                catch (Exception e) {
                    try {
                        refreshUrl = new URL(currURL, url);
                    }
                    catch (Exception e1) {
                        refreshUrl = null;
                    }
                }
            }
        }
        if (metaTags.getRefresh()) {
            if (refreshUrl == null) {
                refreshUrl = currURL;
            }
            metaTags.setRefreshHref(refreshUrl);
        }
    }
}

