/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl.http;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.archive.util.binsearch.impl.HTTPSeekableLineReader;
import org.archive.util.binsearch.impl.HTTPSeekableLineReaderFactory;
import org.archive.util.binsearch.impl.http.ApacheHttp31SLR;

public class ApacheHttp31SLRFactory
extends HTTPSeekableLineReaderFactory {
    private static final Logger LOGGER = Logger.getLogger(ApacheHttp31SLRFactory.class.getName());
    private HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private HostConfiguration hostConfiguration = new HostConfiguration();
    private HttpClient http = null;

    public ApacheHttp31SLRFactory(String uriString) {
        this();
    }

    public ApacheHttp31SLRFactory() {
        HttpClientParams params = new HttpClientParams();
        this.http = new HttpClient(params, this.connectionManager);
        this.http.setHostConfiguration(this.hostConfiguration);
    }

    @Override
    public void close() throws IOException {
        this.connectionManager.closeIdleConnections(0L);
    }

    @Override
    public ApacheHttp31SLR get(String url) throws IOException {
        return new ApacheHttp31SLR(this.http, url);
    }

    @Override
    public void setProxyHostPort(String hostPort) {
        int colonIdx = hostPort.indexOf(58);
        if (colonIdx > 0) {
            String host = hostPort.substring(0, colonIdx);
            int port = Integer.valueOf(hostPort.substring(colonIdx + 1));
            this.hostConfiguration.setProxy(host, port);
        }
    }

    @Override
    public void setMaxTotalConnections(int maxTotalConnections) {
        this.connectionManager.getParams().setMaxTotalConnections(maxTotalConnections);
    }

    @Override
    public int getMaxTotalConnections() {
        return this.connectionManager.getParams().getMaxTotalConnections();
    }

    @Override
    public void setMaxHostConnections(int maxHostConnections) {
        this.connectionManager.getParams().setDefaultMaxConnectionsPerHost(maxHostConnections);
        this.connectionManager.getParams().setMaxConnectionsPerHost(this.hostConfiguration, maxHostConnections);
    }

    @Override
    public int getMaxHostConnections() {
        return this.connectionManager.getParams().getMaxConnectionsPerHost(this.hostConfiguration);
    }

    @Override
    public int getConnectionTimeoutMS() {
        return this.connectionManager.getParams().getConnectionTimeout();
    }

    @Override
    public void setConnectionTimeoutMS(int connectionTimeoutMS) {
        this.connectionManager.getParams().setConnectionTimeout(connectionTimeoutMS);
        this.http.getParams().setConnectionManagerTimeout((long)connectionTimeoutMS);
    }

    @Override
    public int getSocketTimeoutMS() {
        return this.connectionManager.getParams().getSoTimeout();
    }

    @Override
    public void setSocketTimeoutMS(int socketTimeoutMS) {
        this.connectionManager.getParams().setSoTimeout(socketTimeoutMS);
    }

    @Override
    public void setStaleChecking(boolean enabled) {
        this.connectionManager.getParams().setStaleCheckingEnabled(enabled);
    }

    @Override
    public boolean isStaleChecking() {
        return this.connectionManager.getParams().isStaleCheckingEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModTime() {
        HTTPSeekableLineReader reader = null;
        SimpleDateFormat lastModFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
        try {
            reader = this.get();
            String result = reader.getHeaderValue("Last-Modified");
            Date date = lastModFormat.parse(result);
            long l = date.getTime();
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return 0L;
    }

    @Override
    public void setNumRetries(int numRetries) {
        this.http.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(numRetries, true));
    }
}

