/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.archive.url.HandyURL;

public class URLParser {
    public static final Pattern RFC2396REGEX = Pattern.compile("^(([a-zA-Z][a-zA-Z0-9\\+\\-\\.]*):)?((//([^/?#]*))?([^?#]*)(\\?([^#]*))?)?(#(.*))?");
    public static final String COMMERCIAL_AT = "@";
    public static final char PERCENT_SIGN = '%';
    public static final char COLON = ':';
    public static final String STRAY_SPACING = "[\n\r\t\\p{Zl}\\p{Zp}\u0085]+";
    static final Pattern HTTP_SCHEME_SLASHES = Pattern.compile("^(https?://)/+(.*)");
    public static final String DNS_SCHEME = "dns:";
    public static final String FILEDESC_SCHEME = "filedesc:";
    public static final String WARCINFO_SCHEME = "warcinfo:";
    public static final String HTTP_SCHEME = "http://";
    public static final String HTTPS_SCHEME = "https://";
    public static final String FTP_SCHEME = "ftp://";
    public static final String MMS_SCHEME = "mms://";
    public static final String RTSP_SCHEME = "rtsp://";
    public static final String DEFAULT_SCHEME = "http://";
    public static final String WAIS_SCHEME = "wais://";
    public static final String[] ALL_SCHEMES = new String[]{"http://", "https://", "ftp://", "mms://", "rtsp://", "wais://"};
    public static final Pattern ALL_SCHEMES_PATTERN = Pattern.compile("(?i)^(http|https|ftp|mms|rtsp|wais)://.*");

    public static String urlToScheme(String url) {
        for (String scheme : ALL_SCHEMES) {
            if (!url.startsWith(scheme)) continue;
            return scheme;
        }
        return null;
    }

    public static String addDefaultSchemeIfNeeded(String urlString) {
        if (urlString == null) {
            return null;
        }
        Matcher m2 = ALL_SCHEMES_PATTERN.matcher(urlString);
        if (m2.matches()) {
            return urlString;
        }
        return "http://" + urlString;
    }

    public static HandyURL parse(String urlString) throws URISyntaxException {
        Matcher matcher;
        urlString = urlString.trim();
        if ((urlString = urlString.replaceAll(STRAY_SPACING, "")).startsWith(DNS_SCHEME) || urlString.startsWith(FILEDESC_SCHEME) || urlString.startsWith(WARCINFO_SCHEME)) {
            HandyURL h = new HandyURL();
            h.setOpaque(urlString);
            return h;
        }
        Matcher m1 = HTTP_SCHEME_SLASHES.matcher(urlString = URLParser.addDefaultSchemeIfNeeded(urlString));
        if (m1.matches()) {
            urlString = m1.group(1) + m1.group(2);
        }
        if (!(matcher = RFC2396REGEX.matcher(urlString)).matches()) {
            throw new URISyntaxException(urlString, "string does not match RFC 2396 regex");
        }
        String uriScheme = matcher.group(2);
        String uriAuthority = matcher.group(5);
        String uriPath = matcher.group(6);
        String uriQuery = matcher.group(8);
        String uriFragment = matcher.group(10);
        String userName = null;
        String userPass = null;
        String hostname = null;
        int port = -1;
        String userInfo = null;
        String colonPort = null;
        int atIndex = uriAuthority.indexOf(COMMERCIAL_AT);
        int portColonIndex = uriAuthority.indexOf(58, atIndex < 0 ? 0 : atIndex);
        if (atIndex < 0 && portColonIndex < 0) {
            hostname = uriAuthority;
        } else if (atIndex < 0 && portColonIndex > -1) {
            hostname = uriAuthority.substring(0, portColonIndex);
            colonPort = uriAuthority.substring(portColonIndex);
        } else if (atIndex > -1 && portColonIndex < 0) {
            userInfo = uriAuthority.substring(0, atIndex);
            hostname = uriAuthority.substring(atIndex + 1);
        } else {
            userInfo = uriAuthority.substring(0, atIndex);
            hostname = uriAuthority.substring(atIndex + 1, portColonIndex);
            colonPort = uriAuthority.substring(portColonIndex);
        }
        if (colonPort != null && colonPort.startsWith(":") && colonPort.length() != 1) {
            try {
                port = Integer.parseInt(colonPort.substring(1));
            }
            catch (NumberFormatException e) {
                throw new URISyntaxException(urlString, "bad port " + colonPort.substring(1));
            }
        }
        if (userInfo != null) {
            int passColonIndex = userInfo.indexOf(58);
            if (passColonIndex == -1) {
                userName = userInfo;
            } else {
                userName = userInfo.substring(0, passColonIndex);
                userPass = userInfo.substring(passColonIndex + 1);
            }
        }
        return new HandyURL(uriScheme, userName, userPass, hostname, port, uriPath, uriQuery, uriFragment);
    }
}

