/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.warc.record;

import java.io.IOException;
import java.io.InputStream;
import org.archive.format.http.HttpHeaderParser;
import org.archive.format.http.HttpHeaders;
import org.archive.format.http.HttpParseException;
import org.archive.resource.MetaData;
import org.archive.resource.Resource;
import org.archive.resource.ResourceConstants;
import org.archive.resource.ResourceContainer;
import org.archive.resource.ResourceFactory;
import org.archive.resource.ResourceParseException;
import org.archive.resource.warc.record.WARCMetaDataResource;
import org.archive.util.StreamCopy;

public class WARCMetaDataResourceFactory
implements ResourceFactory,
ResourceConstants {
    HttpHeaderParser parser = new HttpHeaderParser();

    @Override
    public Resource getResource(InputStream is, MetaData parentMetaData, ResourceContainer container) throws ResourceParseException, IOException {
        HttpHeaders headers = new HttpHeaders();
        try {
            parentMetaData.putString("Actual-Content-Type", "application/metadata-fields");
            MetaData md = parentMetaData.createChild("WARC-Metadata-Metadata");
            int bytes = this.parser.doParse(is, headers);
            if (headers.isCorrupt()) {
                md.putBoolean("FIELDS_CORRUPT", true);
            }
            parentMetaData.putLong("Trailing-Slop-Length", StreamCopy.readToEOF(is));
            parentMetaData.putLong("Actual-Content-Length", bytes);
            return new WARCMetaDataResource(md, container, headers);
        }
        catch (HttpParseException e) {
            throw new ResourceParseException(e);
        }
    }
}

