/*
 * Decompiled with CFR 0.152.
 */
package org.archive.net;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.util.ProcessUtils;

public abstract class DownloadURLConnection
extends URLConnection {
    private final String CLASSNAME = DownloadURLConnection.class.getName();
    private final Logger LOGGER = Logger.getLogger(this.CLASSNAME);
    private static final File TMPDIR = new File(System.getProperty("java.io.tmpdir", "/tmp"));
    private File downloadFile = null;

    protected DownloadURLConnection(URL u) {
        super(u);
    }

    protected String getScript() {
        return System.getProperty(this.getClass().getName() + ".path", "UNDEFINED");
    }

    protected String[] getCommand(URL thisUrl, File downloadFile) {
        return new String[]{this.getScript(), thisUrl.getPath(), downloadFile.getAbsolutePath()};
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.downloadFile = File.createTempFile(this.CLASSNAME, null, TMPDIR);
        try {
            ProcessUtils.ProcessResult pr;
            Object[] cmd = this.getCommand(this.url, this.downloadFile);
            if (this.LOGGER.isLoggable(Level.FINE)) {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < cmd.length; ++i) {
                    if (i > 0) {
                        buffer.append(" ");
                    }
                    buffer.append((String)cmd[i]);
                }
                this.LOGGER.fine("Command: " + buffer.toString());
            }
            if ((pr = ProcessUtils.exec((String[])cmd)).getResult() != 0) {
                this.LOGGER.info(Arrays.toString(cmd) + " returned non-null " + pr.getResult());
            }
            this.connected = true;
        }
        catch (IOException ioe) {
            this.downloadFile.delete();
            this.downloadFile = null;
            throw ioe;
        }
    }

    public File getFile() {
        return this.downloadFile;
    }

    protected void setFile(File f) {
        this.downloadFile = f;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        final DownloadURLConnection connection = this;
        return new BufferedInputStream(new FileInputStream(this.downloadFile)){
            private DownloadURLConnection ruc;
            {
                super(x0);
                this.ruc = connection;
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (this.ruc != null && this.ruc.getFile() != null && this.ruc.getFile().exists()) {
                    this.ruc.getFile().delete();
                    this.ruc.setFile(null);
                }
            }
        };
    }
}

