/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.warc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.NotImplementedException;
import org.archive.io.ArchiveReader;
import org.archive.io.ArchiveRecord;
import org.archive.io.warc.WARCConstants;
import org.archive.io.warc.WARCReaderFactory;
import org.archive.io.warc.WARCRecord;

public class WARCReader
extends ArchiveReader
implements WARCConstants {
    protected WARCReader() {
    }

    @Override
    protected void initialize(String i) {
        super.initialize(i);
        this.setVersion("1.0");
    }

    @Override
    protected void gotoEOR(ArchiveRecord record) throws IOException {
        if (record.available() != 0) {
            throw new IOException("Record should be exhausted before coming in here");
        }
        this.readExpectedChar(this.getIn(), "\r\n".charAt(0));
        this.readExpectedChar(this.getIn(), "\r\n".charAt(1));
        this.readExpectedChar(this.getIn(), "\r\n".charAt(0));
        this.readExpectedChar(this.getIn(), "\r\n".charAt(1));
    }

    protected void readExpectedChar(InputStream is, int expected) throws IOException {
        int c = is.read();
        if (c != expected) {
            throw new IOException("Unexpected character " + Integer.toHexString(c) + "(Expecting " + Integer.toHexString(expected) + ")");
        }
    }

    @Override
    protected WARCRecord createArchiveRecord(InputStream is, long offset) throws IOException {
        return (WARCRecord)this.currentRecord(new WARCRecord(is, this.getReaderIdentifier(), offset, this.isDigest(), this.isStrict()));
    }

    @Override
    public void dump(boolean compress) throws IOException, java.text.ParseException {
        for (ArchiveRecord r : this) {
            System.out.println(r.getHeader().toString());
            r.dump();
            System.out.println();
        }
    }

    @Override
    public ArchiveReader getDeleteFileOnCloseReader(File f) {
        throw new NotImplementedException("TODO");
    }

    @Override
    public String getDotFileExtension() {
        return ".warc";
    }

    @Override
    public String getFileExtension() {
        return "warc";
    }

    private static void usage(HelpFormatter formatter, Options options, int exitCode) {
        formatter.printHelp("java org.archive.io.arc.WARCReader [--digest=true|false] \\\n [--format=cdx|cdxfile|dump|gzipdump] [--offset=#] \\\n[--strict] [--parse] WARC_FILE|WARC_URL", options);
        System.exit(exitCode);
    }

    protected static void output(WARCReader reader, String format) throws IOException, java.text.ParseException {
        if (!reader.output(format)) {
            throw new IOException("Unsupported format: " + format);
        }
    }

    public static void createCDXIndexFile(String urlOrPath) throws IOException, java.text.ParseException {
        WARCReader r = WARCReaderFactory.get(urlOrPath);
        r.setStrict(false);
        r.setDigest(true);
        WARCReader.output(r, "cdxfile");
    }

    public static void main(String[] args) throws ParseException, IOException, java.text.ParseException {
        Options options = WARCReader.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmdline = parser.parse(options, args, false);
        List cmdlineArgs = cmdline.getArgList();
        Option[] cmdlineOptions = cmdline.getOptions();
        HelpFormatter formatter = new HelpFormatter();
        if (cmdlineArgs.size() <= 0) {
            WARCReader.usage(formatter, options, 0);
        }
        long offset = -1L;
        boolean digest = false;
        boolean strict = false;
        String format = "cdx";
        block9: for (int i = 0; i < cmdlineOptions.length; ++i) {
            switch (cmdlineOptions[i].getId()) {
                case 104: {
                    WARCReader.usage(formatter, options, 0);
                    continue block9;
                }
                case 111: {
                    offset = Long.parseLong(cmdlineOptions[i].getValue());
                    continue block9;
                }
                case 115: {
                    strict = true;
                    continue block9;
                }
                case 100: {
                    digest = WARCReader.getTrueOrFalse(cmdlineOptions[i].getValue());
                    continue block9;
                }
                case 102: {
                    format = cmdlineOptions[i].getValue().toLowerCase();
                    boolean match = false;
                    String[] supportedFormats = new String[]{"cdx", "dump", "gzipdump", "cdxfile"};
                    for (int ii = 0; ii < supportedFormats.length; ++ii) {
                        if (!supportedFormats[ii].equals(format)) continue;
                        match = true;
                        break;
                    }
                    if (match) continue block9;
                    WARCReader.usage(formatter, options, 1);
                    continue block9;
                }
                default: {
                    throw new RuntimeException("Unexpected option: " + cmdlineOptions[i].getId());
                }
            }
        }
        if (offset >= 0L) {
            if (cmdlineArgs.size() != 1) {
                System.out.println("Error: Pass one arcfile only.");
                WARCReader.usage(formatter, options, 1);
            }
            WARCReader r = WARCReaderFactory.get(new File((String)cmdlineArgs.get(0)), offset);
            r.setStrict(strict);
            WARCReader.outputRecord(r, format);
        } else {
            for (String urlOrPath : cmdlineArgs) {
                try {
                    WARCReader r = WARCReaderFactory.get(urlOrPath);
                    r.setStrict(strict);
                    r.setDigest(digest);
                    WARCReader.output(r, format);
                }
                catch (RuntimeException e) {
                    System.err.println("Exception processing " + urlOrPath + ": " + e.getMessage());
                    e.printStackTrace(System.err);
                    System.exit(1);
                }
            }
        }
    }
}

