/*
 * Decompiled with CFR 0.152.
 */
package org.archive.httpclient;

import java.util.logging.Logger;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.archive.util.Recorder;

public class HttpRecorderMethod {
    protected static Logger logger = Logger.getLogger(HttpRecorderMethod.class.getName());
    private Recorder httpRecorder = null;
    private HttpConnection connection = null;

    public HttpRecorderMethod(Recorder recorder) {
        this.httpRecorder = recorder;
    }

    public void markContentBegin(HttpConnection c) {
        if (c != this.connection) {
            throw new IllegalArgumentException("Connections differ: " + this.connection + " " + c + " " + Thread.currentThread().getName());
        }
        this.httpRecorder.markContentBegin();
    }

    public HttpConnection getConnection() {
        return this.connection;
    }

    public void setConnection(HttpConnection connection) {
        this.connection = connection;
    }

    public Recorder getHttpRecorder() {
        return this.httpRecorder;
    }

    public void handleAddProxyConnectionHeader(HttpMethod method) {
        Header h = method.getRequestHeader("Proxy-Connection");
        if (h != null) {
            h.setValue("close");
            method.setRequestHeader(h);
        }
    }
}

