/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip.zipnum;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.format.gzip.zipnum.ZipNumIndex;
import org.archive.format.gzip.zipnum.ZipNumParams;
import org.archive.util.ArchiveUtils;
import org.archive.util.GeneralURIStreamFactory;
import org.archive.util.binsearch.SeekableLineReader;
import org.archive.util.binsearch.SeekableLineReaderFactory;
import org.archive.util.binsearch.SeekableLineReaderIterator;
import org.archive.util.binsearch.impl.HTTPSeekableLineReader;
import org.archive.util.iterator.CloseableIterator;

public class ZipNumCluster
extends ZipNumIndex {
    static final Logger LOGGER = Logger.getLogger(ZipNumCluster.class.getName());
    protected static final CloseableIterator<String> EMPTY_ITERATOR = new CloseableIterator<String>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() throws IOException {
        }
    };
    protected HashMap<String, String[]> locMap = null;
    protected SeekableLineReaderFactory locReaderFactory = null;
    protected String locFile;
    protected long lastModTime = 0L;
    protected int checkInterval = 30000;
    protected Thread updaterThread;
    public static final String EARLIEST_TIMESTAMP = "_EARLIEST";
    public static final String LATEST_TIMESTAMP = "_LATEST";
    public static final String OFF = "OFF";
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    protected Date startDate;
    protected Date endDate;
    protected BlockSize[] lastBlockSizes = new BlockSize[0];
    protected String blockSizesFile;
    protected String locRoot = null;
    protected String newLocRoot = null;
    protected long totalAdjustment = 0L;
    protected Date newStartDate;
    protected Date newEndDate;
    protected boolean newIsDisabled = false;
    protected boolean disabled = false;
    protected ConcurrentHashMap<String, LocCacheEntry> locCacheMap;
    protected boolean cacheRemoteLoc = false;
    protected int locCacheExpireMillis = 120000;
    protected int locCacheMaxDuration = 1000;

    @Override
    public void init() throws IOException {
        super.init();
        this.blockSizesFile = this.locFile.replaceAll(".loc", ".lastblocks");
        this.locMap = new HashMap();
        if (this.cacheRemoteLoc) {
            this.locCacheMap = new ConcurrentHashMap();
        }
        try {
            this.locReaderFactory = GeneralURIStreamFactory.createSeekableStreamFactory(this.locFile, false);
            this.lastModTime = this.locReaderFactory.getModTime();
            this.loadPartLocations(this.locMap);
        }
        catch (IOException io) {
            LOGGER.warning("Exception on Load -- Disabling Cluster! " + io.toString());
            this.disabled = true;
            return;
        }
        this.disabled = this.newIsDisabled;
        this.startDate = this.newStartDate;
        this.endDate = this.newEndDate;
        this.locRoot = this.newLocRoot;
        this.cdxLinesTotalCount = this.computeTotalLines();
        if (!this.disabled) {
            this.loadLastBlockSizes(this.blockSizesFile);
        }
        if (this.checkInterval > 0) {
            this.updaterThread = new Thread((Runnable)new LocationUpdater(), "LocationUpdaterThread");
            this.updaterThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncLoad(long newModTime) {
        HashMap<String, String[]> destMap = new HashMap<String, String[]>();
        try {
            this.loadPartLocations(destMap);
        }
        catch (IOException e) {
            LOGGER.warning(e.toString());
            return;
        }
        if (!this.disabled) {
            this.loadLastBlockSizes(this.blockSizesFile);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("*** Location Update: " + this.locFile);
        }
        ArrayList<String[]> filesToClose = new ArrayList<String[]>();
        ZipNumCluster zipNumCluster = this;
        synchronized (zipNumCluster) {
            for (Map.Entry<String, String[]> files : destMap.entrySet()) {
                Object[] existingFiles = this.locMap.get(files.getKey());
                Object[] newFiles = files.getValue();
                if (existingFiles != null && !Arrays.equals(existingFiles, newFiles)) {
                    filesToClose.add((String[])existingFiles);
                }
                this.locMap.put(files.getKey(), (String[])newFiles);
            }
            this.startDate = this.newStartDate;
            this.endDate = this.newEndDate;
            this.disabled = this.newIsDisabled;
            this.locRoot = this.newLocRoot;
            this.cdxLinesTotalCount = this.computeTotalLines();
        }
        if (this.locCacheMap != null) {
            this.locCacheMap.clear();
        }
        this.closeExistingFiles(filesToClose);
        this.lastModTime = newModTime;
    }

    private void closeExistingFiles(ArrayList<String[]> filesToClose) {
        for (String[] files : filesToClose) {
            for (String file : files) {
                try {
                    this.blockLoader.closeFileFactory(file);
                }
                catch (IOException e) {
                    LOGGER.warning(e.toString());
                }
            }
        }
    }

    public synchronized String[] getLocations(String key) {
        return this.locMap.get(key);
    }

    public String getLocRoot() {
        return this.locRoot;
    }

    public String getLocFile() {
        return this.locFile;
    }

    public void setLocFile(String locFile) {
        this.locFile = locFile;
    }

    public int getLocCacheExpireMillis() {
        return this.locCacheExpireMillis;
    }

    public void setLocCacheExpireMillis(int locCacheExpireMillis) {
        this.locCacheExpireMillis = locCacheExpireMillis;
    }

    public int getLocCacheMaxDuration() {
        return this.locCacheMaxDuration;
    }

    public void setLocCacheMaxDuration(int locCacheMaxDuration) {
        this.locCacheMaxDuration = locCacheMaxDuration;
    }

    public boolean isCacheRemoteLoc() {
        return this.cacheRemoteLoc;
    }

    public void setCacheRemoteLoc(boolean cacheRemoteLoc) {
        this.cacheRemoteLoc = cacheRemoteLoc;
    }

    protected Date parseDate(String date) {
        try {
            return this.dateFormat.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public boolean dateRangeCheck(String key) {
        if (this.disabled) {
            return false;
        }
        if (this.startDate == null && this.endDate == null) {
            return true;
        }
        int spaceIndex = key.indexOf(32);
        if (spaceIndex < 0) {
            return true;
        }
        String dateStr = key.substring(spaceIndex + 1);
        Date reqDate = null;
        try {
            reqDate = ArchiveUtils.getDate(dateStr);
        }
        catch (ParseException e) {
            return true;
        }
        if (this.startDate != null && reqDate.before(this.startDate)) {
            return false;
        }
        return this.endDate == null || !reqDate.after(this.endDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLastBlockSizes(String filename) {
        BufferedReader reader = null;
        String line = null;
        ArrayList<BlockSize> list = new ArrayList<BlockSize>();
        this.totalAdjustment = 0L;
        try {
            reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                String[] splits = line.split("\t");
                BlockSize block = new BlockSize();
                block.count = Long.parseLong(splits[1]);
                block.urltimestamp = splits[2];
                list.add(block);
                this.totalAdjustment += block.count;
            }
        }
        catch (Exception e) {
            LOGGER.warning(e.toString());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.warning(e.toString());
                }
            }
        }
        this.lastBlockSizes = list.toArray(new BlockSize[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPartLocations(HashMap<String, String[]> destMap) throws IOException {
        SeekableLineReaderIterator lines = null;
        this.newEndDate = null;
        this.newStartDate = null;
        this.newIsDisabled = false;
        try {
            lines = new SeekableLineReaderIterator(this.locReaderFactory.get());
            while (lines.hasNext()) {
                String line = (String)lines.next();
                if (line.isEmpty()) continue;
                String[] parts = line.split("\\t");
                if (parts[0].equals(OFF)) {
                    this.newIsDisabled = true;
                    break;
                }
                if (parts.length < 2) {
                    String msg = "Bad line(" + line + ") in (" + this.locFile + ")";
                    LOGGER.warning(msg);
                    continue;
                }
                if (parts[0].equals(EARLIEST_TIMESTAMP)) {
                    this.newStartDate = this.parseDate(parts[1]);
                    continue;
                }
                if (parts[0].equals(LATEST_TIMESTAMP)) {
                    this.newEndDate = this.parseDate(parts[1]);
                    continue;
                }
                String[] locations = new String[parts.length - 1];
                if (this.newLocRoot == null) {
                    int lastSlash = parts[1].lastIndexOf(47);
                    this.newLocRoot = parts[1].substring(0, lastSlash + 1);
                }
                for (int i = 1; i < parts.length; ++i) {
                    locations[i - 1] = parts[i];
                }
                destMap.put(parts[0], locations);
            }
        }
        finally {
            if (lines != null) {
                lines.close();
            }
        }
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval;
    }

    public long getTotalAdjustment() {
        return this.totalAdjustment;
    }

    public int getNumBlocks() {
        return this.lastBlockSizes.length;
    }

    public long getLastBlockDiff(String startKey, int startPart, int endPart) {
        if (startPart >= this.lastBlockSizes.length || endPart >= this.lastBlockSizes.length) {
            return 0L;
        }
        if (startKey.equals(this.lastBlockSizes[startPart].urltimestamp)) {
            ++startPart;
        }
        long diff = 0L;
        for (int i = startPart; i < endPart; ++i) {
            diff += this.lastBlockSizes[i].count;
            diff -= (long)this.getCdxLinesPerBlock();
        }
        return diff;
    }

    public long computeTotalLines() {
        long numLines = 0L;
        try {
            numLines = this.getNumLines(this.summary.getRange("", ""));
        }
        catch (IOException e) {
            LOGGER.warning(e.toString());
            return 0L;
        }
        long adjustment = this.getTotalAdjustment();
        numLines -= (long)(this.getNumBlocks() - 1);
        numLines *= (long)this.getCdxLinesPerBlock();
        return numLines += adjustment;
    }

    @Override
    public CloseableIterator<String> getCDXIterator(String key, String start, String end, ZipNumParams params) throws IOException {
        if (!this.dateRangeCheck(key)) {
            return EMPTY_ITERATOR;
        }
        return super.getCDXIterator(key, start, end, params);
    }

    @Override
    public CloseableIterator<String> getCDXIterator(String key, String prefix, boolean exact, ZipNumParams params) throws IOException {
        if (!this.dateRangeCheck(key)) {
            return EMPTY_ITERATOR;
        }
        return super.getCDXIterator(key, prefix, exact, params);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    SeekableLineReader doBlockLoad(String partId, long startOffset, int totalLength) {
        SeekableLineReader reader = null;
        String[] locations = this.getLocations(partId);
        if (locations == null) {
            LOGGER.severe("No locations for block(" + partId + ")");
            return null;
        }
        if (this.cacheRemoteLoc && this.locCacheMap != null && locations.length > 0 && GeneralURIStreamFactory.isHttp(locations[0])) {
            reader = this.loadCachedBalancedReader(partId, locations, startOffset, totalLength);
        } else {
            for (String location : locations) {
                reader = this.blockLoader.attemptLoadBlock(location, startOffset, totalLength, true, this.isRequired());
                if (reader == null) continue;
                return reader;
            }
        }
        return reader;
    }

    protected String locCacheGet(String key) {
        LocCacheEntry entry = this.locCacheMap.get(key);
        if (entry == null) {
            return null;
        }
        if (System.currentTimeMillis() > entry.expire) {
            this.locCacheMap.remove(key);
            return null;
        }
        return entry.loc;
    }

    protected void locCachePut(String key, String loc) {
        this.locCacheMap.putIfAbsent(key, new LocCacheEntry(loc, System.currentTimeMillis() + (long)this.locCacheExpireMillis));
    }

    SeekableLineReader loadCachedBalancedReader(String partId, String[] locations, long offset, int length) {
        SeekableLineReader reader = null;
        String cachedUrl = this.locCacheGet(partId);
        if (cachedUrl != null) {
            long start = System.currentTimeMillis();
            reader = this.blockLoader.attemptLoadBlock(cachedUrl, offset, length, true, false);
            long duration = System.currentTimeMillis() - start;
            if (reader == null || duration > (long)this.locCacheMaxDuration) {
                this.locCacheMap.remove(partId, cachedUrl);
            }
            if (reader != null) {
                return reader;
            }
        }
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        for (int i = 0; i < locations.length; ++i) {
            indexs.add(i);
        }
        if (locations.length > 1) {
            Collections.shuffle(indexs);
        }
        int lastIndex = locations.length - 1;
        for (int i = 0; i < indexs.size(); ++i) {
            int index = (Integer)indexs.get(i);
            if (cachedUrl != null && locations[index].equals(cachedUrl)) continue;
            long start = System.currentTimeMillis();
            boolean required = this.isRequired() && i == lastIndex;
            reader = this.blockLoader.attemptLoadBlock(locations[index], offset, length, true, required);
            long duration = System.currentTimeMillis() - start;
            if (reader == null) continue;
            String connectedUrl = ((HTTPSeekableLineReader)reader).getConnectedUrl();
            if (duration < (long)this.locCacheMaxDuration && connectedUrl != null) {
                this.locCachePut(partId, connectedUrl);
            }
            return reader;
        }
        return reader;
    }

    class LocCacheEntry {
        String loc;
        long expire;

        LocCacheEntry(String loc, long expire) {
            this.loc = loc;
            this.expire = expire;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof String) {
                return this.loc.equals(obj);
            }
            if (obj instanceof LocCacheEntry) {
                return this.loc.equals(((LocCacheEntry)obj).loc);
            }
            return false;
        }
    }

    class BlockSize {
        String urltimestamp;
        long count;

        BlockSize() {
        }
    }

    private class LocationUpdater
    implements Runnable {
        private LocationUpdater() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    long currModTime;
                    if ((currModTime = ZipNumCluster.this.locReaderFactory.getModTime()) != ZipNumCluster.this.lastModTime) {
                        ZipNumCluster.this.syncLoad(currModTime);
                        Thread.sleep(ZipNumCluster.this.checkInterval);
                        if (ZipNumCluster.this.summary != null) {
                            ZipNumCluster.this.summary.reloadFactory();
                        }
                    }
                    Thread.sleep(ZipNumCluster.this.checkInterval);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

