/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.cdx;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.archive.format.cdx.FieldSplitFormat;

public class FieldSplitLine {
    protected FieldSplitFormat names;
    protected String fullLine;
    protected List<String> fields;
    public static final String EMPTY_VALUE = "-";

    protected FieldSplitLine(String line, List<String> fields, FieldSplitFormat names) {
        this.fullLine = line;
        this.fields = fields;
        this.names = names;
    }

    public FieldSplitLine(List<String> fields, FieldSplitFormat names) {
        this(null, fields, names);
    }

    public FieldSplitLine(String line, char splitchar, FieldSplitFormat names) {
        this.fullLine = line;
        this.names = names;
        if (line == null) {
            this.fields = null;
            return;
        }
        int initSize = names != null ? names.getLength() : 0;
        this.fields = new ArrayList<String>(initSize);
        int lastIndex = 0;
        int currIndex = line.indexOf(splitchar);
        do {
            if ((currIndex = line.indexOf(splitchar, lastIndex)) <= 0) {
                this.fields.add(line.substring(lastIndex));
                break;
            }
            this.fields.add(line.substring(lastIndex, currIndex));
        } while ((lastIndex = currIndex + 1) > 0);
        if (names != null) {
            while (this.fields.size() < initSize) {
                this.fields.add(EMPTY_VALUE);
            }
        }
    }

    public int getFieldIndex(String name) {
        if (this.names == null) {
            return -1;
        }
        return this.names.getFieldIndex(name);
    }

    public boolean isInRange(int index) {
        return index >= 0 && index < this.fields.size();
    }

    public String getField(String name, String defaultVal) {
        int index = this.getFieldIndex(name);
        return this.isInRange(index) ? this.fields.get(index) : defaultVal;
    }

    public String getField(String name) {
        return this.getField(name, EMPTY_VALUE);
    }

    public String toString() {
        if (this.fullLine == null && this.fields != null) {
            this.fullLine = StringUtils.join(this.fields, (String)" ");
        }
        return this.fullLine;
    }

    public String getField(int index) {
        return this.fields.get(index);
    }

    public String setField(int index, String value) {
        return this.fields.set(index, value);
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public List<String> selectValues(FieldSplitFormat otherNames) {
        ArrayList<String> values = new ArrayList<String>(otherNames.getLength());
        for (int i = 0; i < otherNames.getLength(); ++i) {
            int index = this.names.getFieldIndex(otherNames.getName(i));
            if (this.isInRange(index)) {
                values.add(this.fields.get(index));
                continue;
            }
            values.add(EMPTY_VALUE);
        }
        return values;
    }

    public FieldSplitFormat getNames() {
        return this.names;
    }

    public void setField(String fieldName, String value) {
        int index = this.getFieldIndex(fieldName);
        if (this.isInRange(index)) {
            this.fields.set(index, value);
            this.fullLine = null;
        }
    }
}

