/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.tld;

import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.indexer.NutchField;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.scoring.AbstractScoringFilter;
import org.apache.nutch.scoring.ScoringFilterException;
import org.apache.nutch.util.domain.DomainSuffix;
import org.apache.nutch.util.domain.DomainSuffixes;

public class TLDScoringFilter
extends AbstractScoringFilter {
    private DomainSuffixes tldEntries = DomainSuffixes.getInstance();

    public float indexerScore(Text url, NutchDocument doc, CrawlDatum dbDatum, CrawlDatum fetchDatum, Parse parse, Inlinks inlinks, float initScore) throws ScoringFilterException {
        NutchField tlds = doc.getField("tld");
        float boost = 1.0f;
        if (tlds != null) {
            for (Object tld : tlds.getValues()) {
                DomainSuffix entry = this.tldEntries.get(tld.toString());
                if (entry == null) continue;
                boost *= entry.getBoost();
            }
        }
        return initScore * boost;
    }
}

