/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util.domain;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.util.domain.DomainSuffix;
import org.apache.nutch.util.domain.DomainSuffixes;
import org.apache.nutch.util.domain.TopLevelDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DomainSuffixesReader {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    DomainSuffixesReader() {
    }

    void read(DomainSuffixes tldEntries, InputStream input) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(input));
            Element root = document.getDocumentElement();
            if (root == null || !root.getTagName().equals("domains")) {
                throw new IOException("xml file is not valid");
            }
            Element tlds = (Element)root.getElementsByTagName("tlds").item(0);
            Element suffixes = (Element)root.getElementsByTagName("suffixes").item(0);
            this.readITLDs(tldEntries, (Element)tlds.getElementsByTagName("itlds").item(0));
            this.readGTLDs(tldEntries, (Element)tlds.getElementsByTagName("gtlds").item(0));
            this.readCCTLDs(tldEntries, (Element)tlds.getElementsByTagName("cctlds").item(0));
            this.readSuffixes(tldEntries, suffixes);
        }
        catch (ParserConfigurationException ex) {
            LOG.warn(StringUtils.stringifyException((Throwable)ex));
            throw new IOException(ex.getMessage());
        }
        catch (SAXException ex) {
            LOG.warn(StringUtils.stringifyException((Throwable)ex));
            throw new IOException(ex.getMessage());
        }
    }

    void readITLDs(DomainSuffixes tldEntries, Element el) {
        NodeList children = el.getElementsByTagName("tld");
        for (int i = 0; i < children.getLength(); ++i) {
            tldEntries.addDomainSuffix(this.readGTLD((Element)children.item(i), TopLevelDomain.Type.INFRASTRUCTURE));
        }
    }

    void readGTLDs(DomainSuffixes tldEntries, Element el) {
        NodeList children = el.getElementsByTagName("tld");
        for (int i = 0; i < children.getLength(); ++i) {
            tldEntries.addDomainSuffix(this.readGTLD((Element)children.item(i), TopLevelDomain.Type.GENERIC));
        }
    }

    void readCCTLDs(DomainSuffixes tldEntries, Element el) throws IOException {
        NodeList children = el.getElementsByTagName("tld");
        for (int i = 0; i < children.getLength(); ++i) {
            tldEntries.addDomainSuffix(this.readCCTLD((Element)children.item(i)));
        }
    }

    TopLevelDomain readGTLD(Element el, TopLevelDomain.Type type) {
        String domain = el.getAttribute("domain");
        DomainSuffix.Status status = this.readStatus(el);
        float boost = this.readBoost(el);
        return new TopLevelDomain(domain, type, status, boost);
    }

    TopLevelDomain readCCTLD(Element el) throws IOException {
        String domain = el.getAttribute("domain");
        DomainSuffix.Status status = this.readStatus(el);
        float boost = this.readBoost(el);
        String countryName = this.readCountryName(el);
        return new TopLevelDomain(domain, status, boost, countryName);
    }

    DomainSuffix.Status readStatus(Element el) {
        NodeList list = el.getElementsByTagName("status");
        if (list == null || list.getLength() == 0) {
            return DomainSuffix.DEFAULT_STATUS;
        }
        return DomainSuffix.Status.valueOf(list.item(0).getFirstChild().getNodeValue());
    }

    float readBoost(Element el) {
        NodeList list = el.getElementsByTagName("boost");
        if (list == null || list.getLength() == 0) {
            return 1.0f;
        }
        return Float.parseFloat(list.item(0).getFirstChild().getNodeValue());
    }

    String readCountryName(Element el) throws IOException {
        NodeList list = el.getElementsByTagName("country");
        if (list == null || list.getLength() == 0) {
            throw new IOException("Country name should be given");
        }
        return list.item(0).getNodeValue();
    }

    void readSuffixes(DomainSuffixes tldEntries, Element el) {
        NodeList children = el.getElementsByTagName("suffix");
        for (int i = 0; i < children.getLength(); ++i) {
            tldEntries.addDomainSuffix(this.readSuffix((Element)children.item(i)));
        }
    }

    DomainSuffix readSuffix(Element el) {
        String domain = el.getAttribute("domain");
        DomainSuffix.Status status = this.readStatus(el);
        float boost = this.readBoost(el);
        return new DomainSuffix(domain, status, boost);
    }
}

