/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Nutch;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolStatusStatistics
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Text UNFETCHED_TEXT = new Text("UNFETCHED");

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: ProtocolStatistics inputDirs outDir [numOfReducer]");
            System.err.println("\tinputDirs\tComma separated list of crawldb input directories");
            System.err.println("\t\t\tE.g.: crawl/crawldb/");
            System.err.println("\toutDir\t\tOutput directory where results should be dumped");
            System.err.println("\t[numOfReducers]\tOptional number of reduce jobs to use. Defaults to 1.");
            return 1;
        }
        String inputDir = args[0];
        String outputDir = args[1];
        int numOfReducers = 1;
        if (args.length > 2) {
            numOfReducers = Integer.parseInt(args[2]);
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LOG.info("ProtocolStatistics: starting");
        String jobName = "Nutch ProtocolStatusStatistics: " + inputDir;
        Configuration conf = this.getConf();
        conf.setBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
        Job job = Job.getInstance((Configuration)conf, (String)jobName);
        job.setJarByClass(ProtocolStatusStatistics.class);
        String[] inputDirsSpecs = inputDir.split(",");
        for (int i = 0; i < inputDirsSpecs.length; ++i) {
            FileInputFormat.addInputPath((Job)job, (Path)new Path(inputDirsSpecs[i], "current"));
        }
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputDir));
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(LongWritable.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(ProtocolStatusStatisticsMapper.class);
        job.setReducerClass(ProtocolStatusStatisticsReducer.class);
        job.setCombinerClass(ProtocolStatusStatisticsCombiner.class);
        job.setNumReduceTasks(numOfReducers);
        try {
            boolean success = job.waitForCompletion(true);
            if (!success) {
                String message = NutchJob.getJobFailureLogMessage(jobName, job);
                LOG.error(message);
                throw new RuntimeException(message);
            }
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            LOG.error(jobName + " job failed", (Throwable)e);
            throw e;
        }
        stopWatch.stop();
        LOG.info("ProtocolStatistics: finished, elapsed: {} ms", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new ProtocolStatusStatistics(), (String[])args);
    }

    public static class ProtocolStatusStatisticsCombiner
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long total = 0L;
            for (LongWritable val : values) {
                total += val.get();
            }
            context.write((Object)key, (Object)new LongWritable(total));
        }
    }

    static class ProtocolStatusStatisticsReducer
    extends Reducer<Text, LongWritable, LongWritable, Text> {
        ProtocolStatusStatisticsReducer() {
        }

        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long total = 0L;
            for (LongWritable val : values) {
                total += val.get();
            }
            context.write((Object)new LongWritable(total), (Object)key);
        }
    }

    static class ProtocolStatusStatisticsMapper
    extends Mapper<Text, CrawlDatum, Text, LongWritable> {
        ProtocolStatusStatisticsMapper() {
        }

        public void map(Text urlText, CrawlDatum datum, Mapper.Context context) throws IOException, InterruptedException {
            if (datum.getMetaData().containsKey((Object)Nutch.PROTOCOL_STATUS_CODE_KEY)) {
                context.write((Object)((Text)datum.getMetaData().get((Object)Nutch.PROTOCOL_STATUS_CODE_KEY)), (Object)new LongWritable(1L));
            } else {
                context.write((Object)UNFETCHED_TEXT, (Object)new LongWritable(1L));
            }
        }
    }
}

