/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class LockUtil {
    public static void createLockFile(FileSystem fs, Path lockFile, boolean accept) throws IOException {
        if (fs.exists(lockFile)) {
            if (!accept) {
                throw new IOException("lock file " + lockFile + " already exists.");
            }
            if (fs.getFileStatus(lockFile).isDirectory()) {
                throw new IOException("lock file " + lockFile + " already exists and is a directory.");
            }
        } else {
            fs.mkdirs(lockFile.getParent());
            fs.createNewFile(lockFile);
        }
    }

    public static void createLockFile(Configuration conf, Path lockFile, boolean accept) throws IOException {
        FileSystem fs = lockFile.getFileSystem(conf);
        LockUtil.createLockFile(fs, lockFile, accept);
    }

    public static boolean removeLockFile(FileSystem fs, Path lockFile) throws IOException {
        if (!fs.exists(lockFile)) {
            return false;
        }
        if (fs.getFileStatus(lockFile).isDirectory()) {
            throw new IOException("lock file " + lockFile + " exists but is a directory!");
        }
        return fs.delete(lockFile, false);
    }

    public static boolean removeLockFile(Configuration conf, Path lockFile) throws IOException {
        FileSystem fs = lockFile.getFileSystem(conf);
        return LockUtil.removeLockFile(fs, lockFile);
    }
}

