/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern DATE_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z");

    public static JexlScript parseExpression(String expr) {
        if (expr == null) {
            return null;
        }
        try {
            Matcher matcher = DATE_PATTERN.matcher(expr);
            if (matcher.find()) {
                String date = matcher.group();
                Date parsedDate = DateUtils.parseDateStrictly((String)date, (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'"});
                long time = parsedDate.getTime();
                expr = expr.replace(date, Long.toString(time));
            }
            JexlEngine jexl = new JexlBuilder().silent(true).strict(true).create();
            return jexl.createScript(expr);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }
}

