/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlCompletionStats
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MODE_HOST = 1;
    private static final int MODE_DOMAIN = 2;

    public int run(String[] args) throws Exception {
        CommandLine cli;
        Option helpOpt = new Option("h", "help", false, "Show this message");
        OptionBuilder.withArgName((String)"inputDirs");
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"Comma separated list of crawldb directories (e.g., \"./crawl1/crawldb,./crawl2/crawldb\")");
        OptionBuilder.hasArgs();
        Option inDirs = OptionBuilder.create((String)"inputDirs");
        OptionBuilder.withArgName((String)"outputDir");
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"Output directory where results should be dumped");
        OptionBuilder.hasArgs();
        Option outDir = OptionBuilder.create((String)"outputDir");
        OptionBuilder.withArgName((String)"mode");
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"Set statistics gathering mode (by 'host' or by 'domain')");
        OptionBuilder.hasArgs();
        Option modeOpt = OptionBuilder.create((String)"mode");
        OptionBuilder.withArgName((String)"numReducers");
        OptionBuilder.withDescription((String)"Optional number of reduce jobs to use. Defaults to 1");
        OptionBuilder.hasArgs();
        Option numReducers = OptionBuilder.create((String)"numReducers");
        Options options = new Options();
        options.addOption(helpOpt);
        options.addOption(inDirs);
        options.addOption(outDir);
        options.addOption(modeOpt);
        options.addOption(numReducers);
        GnuParser parser = new GnuParser();
        try {
            cli = parser.parse(options, args);
        }
        catch (MissingOptionException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("CrawlCompletionStats", options, true);
            return 1;
        }
        if (cli.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("CrawlCompletionStats", options, true);
            return 1;
        }
        String inputDir = cli.getOptionValue("inputDirs");
        String outputDir = cli.getOptionValue("outputDir");
        int numOfReducers = 1;
        if (cli.hasOption("numReducers")) {
            numOfReducers = Integer.parseInt(args[3]);
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LOG.info("CrawlCompletionStats: starting");
        int mode = 0;
        Object jobName = "Nutch CrawlCompletionStats: ";
        if (cli.getOptionValue("mode").equals("host")) {
            jobName = (String)jobName + "Host statistics";
            mode = 1;
        } else if (cli.getOptionValue("mode").equals("domain")) {
            jobName = (String)jobName + "Domain statistics";
            mode = 2;
        }
        Configuration conf = this.getConf();
        conf.setInt("domain.statistics.mode", mode);
        conf.setBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
        Job job = Job.getInstance((Configuration)conf, (String)jobName);
        job.setJarByClass(CrawlCompletionStats.class);
        String[] inputDirsSpecs = inputDir.split(",");
        for (int i = 0; i < inputDirsSpecs.length; ++i) {
            FileInputFormat.addInputPath((Job)job, (Path)new Path(inputDirsSpecs[i], "current"));
        }
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputDir));
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(LongWritable.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(CrawlCompletionStatsMapper.class);
        job.setReducerClass(CrawlCompletionStatsReducer.class);
        job.setCombinerClass(CrawlCompletionStatsCombiner.class);
        job.setNumReduceTasks(numOfReducers);
        try {
            boolean success = job.waitForCompletion(true);
            if (!success) {
                String message = NutchJob.getJobFailureLogMessage((String)jobName, job);
                LOG.error(message);
                throw new RuntimeException(message);
            }
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            LOG.error((String)jobName + " job failed");
            throw e;
        }
        stopWatch.stop();
        LOG.info("CrawlCompletionStats: finished, elapsed: {} ms", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new CrawlCompletionStats(), (String[])args);
    }

    public static class CrawlCompletionStatsCombiner
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long total = 0L;
            for (LongWritable val : values) {
                total += val.get();
            }
            context.write((Object)key, (Object)new LongWritable(total));
        }
    }

    static class CrawlCompletionStatsReducer
    extends Reducer<Text, LongWritable, LongWritable, Text> {
        CrawlCompletionStatsReducer() {
        }

        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long total = 0L;
            for (LongWritable val : values) {
                total += val.get();
            }
            context.write((Object)new LongWritable(total), (Object)key);
        }
    }

    static class CrawlCompletionStatsMapper
    extends Mapper<Text, CrawlDatum, Text, LongWritable> {
        int mode = 0;

        CrawlCompletionStatsMapper() {
        }

        public void setup(Mapper.Context context) {
            this.mode = context.getConfiguration().getInt("domain.statistics.mode", 2);
        }

        public void map(Text urlText, CrawlDatum datum, Mapper.Context context) throws IOException, InterruptedException {
            URL url;
            try {
                url = new URL(urlText.toString());
            }
            catch (MalformedURLException e) {
                LOG.error("Failed to get host or domain from URL {}: {}", (Object)urlText, (Object)e.getMessage());
                return;
            }
            String out = "";
            switch (this.mode) {
                case 1: {
                    out = url.getHost();
                    break;
                }
                case 2: {
                    out = URLUtil.getDomainName(url);
                }
            }
            if (datum.getStatus() == 2 || datum.getStatus() == 6) {
                context.write((Object)new Text(out + " FETCHED"), (Object)new LongWritable(1L));
            } else {
                context.write((Object)new Text(out + " UNFETCHED"), (Object)new LongWritable(1L));
            }
        }
    }
}

