/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import crawlercommons.robots.BaseRobotRules;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.Tool;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.protocol.Protocol;
import org.apache.nutch.protocol.ProtocolFactory;
import org.apache.nutch.protocol.ProtocolOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChecker
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected boolean keepClientCnxOpen = false;
    protected int tcpPort = -1;
    protected boolean stdin = true;
    protected String usage;

    protected abstract int process(String var1, StringBuilder var2) throws Exception;

    protected int parseArgs(String[] args, int i) {
        if (args[i].equals("-listen")) {
            this.tcpPort = Integer.parseInt(args[++i]);
            return 2;
        }
        if (args[i].equals("-keepClientCnxOpen")) {
            this.keepClientCnxOpen = true;
            return 1;
        }
        if (args[i].equals("-stdin")) {
            this.stdin = true;
            return 1;
        }
        return 0;
    }

    protected int run() throws Exception {
        if (this.tcpPort != -1) {
            return this.processTCP(this.tcpPort);
        }
        if (this.stdin) {
            return this.processStdin();
        }
        return -1;
    }

    protected int processSingle(String input) throws Exception {
        StringBuilder output = new StringBuilder();
        int ret = this.process(input, output);
        System.out.println(output);
        return ret;
    }

    protected int processStdin() throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = in.readLine()) != null) {
            StringBuilder output = new StringBuilder();
            int ret = this.process(line, output);
            System.out.println(output);
        }
        return 0;
    }

    protected int processTCP(int tcpPort) throws Exception {
        ServerSocket server = null;
        try {
            server = new ServerSocket();
            server.bind(new InetSocketAddress(tcpPort));
            LOG.info(server.toString());
        }
        catch (Exception e) {
            LOG.error("Could not listen on port " + tcpPort, (Throwable)e);
            return -1;
        }
        try {
            while (true) {
                Worker worker = new Worker(server.accept());
                Thread thread = new Thread(worker);
                thread.start();
            }
        }
        catch (Exception e) {
            LOG.error("Accept failed: " + tcpPort, (Throwable)e);
            return -1;
        }
    }

    protected ProtocolOutput getProtocolOutput(String url, CrawlDatum datum, boolean checkRobotsTxt) throws Exception {
        ProtocolFactory factory = new ProtocolFactory(this.getConf());
        Protocol protocol = factory.getProtocol(url);
        Text turl = new Text(url);
        if (checkRobotsTxt) {
            System.err.print("Checking robots.txt ...");
            BaseRobotRules rules = protocol.getRobotRules(turl, datum, null);
            if (rules.isAllowed(url)) {
                System.err.println(" (allowed)");
            } else {
                System.err.println("\nDenied by robots.txt: " + url);
                return null;
            }
        }
        return protocol.getProtocolOutput(turl, datum);
    }

    private class Worker
    implements Runnable {
        private Socket client;

        Worker(Socket client) {
            this.client = client;
            LOG.info(client.toString());
        }

        @Override
        public void run() {
            BufferedReader in = null;
            OutputStream out = null;
            try {
                in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
                out = this.client.getOutputStream();
            }
            catch (IOException e) {
                LOG.error("Failed initializing streams: ", (Throwable)e);
                return;
            }
            if (AbstractChecker.this.keepClientCnxOpen) {
                try {
                    while (this.readWrite(in, out)) {
                    }
                }
                catch (Exception e) {
                    LOG.error("Read/Write failed: ", (Throwable)e);
                }
            } else {
                try {
                    this.readWrite(in, out);
                }
                catch (Exception e) {
                    LOG.error("Read/Write failed: ", (Throwable)e);
                }
            }
            try {
                this.client.close();
            }
            catch (Exception e) {
                LOG.error(e.toString());
            }
        }

        protected boolean readWrite(BufferedReader in, OutputStream out) throws Exception {
            String line = in.readLine();
            if (line == null) {
                return false;
            }
            if (line.trim().length() > 1) {
                StringBuilder output = new StringBuilder();
                AbstractChecker.this.process(line, output);
                output.append("\n");
                out.write(output.toString().getBytes(StandardCharsets.UTF_8));
            }
            return true;
        }
    }
}

