/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.List;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.tools.CommonCrawlConfig;
import org.apache.nutch.tools.CommonCrawlFormat;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommonCrawlFormat
implements CommonCrawlFormat {
    protected static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected String url;
    protected Content content;
    protected Metadata metadata;
    protected Configuration conf;
    protected String keyPrefix;
    protected boolean simpleDateFormat;
    protected boolean jsonArray;
    protected boolean reverseKey;
    protected String reverseKeyValue;
    protected List<String> inLinks;

    public AbstractCommonCrawlFormat(String url, Content content, Metadata metadata, Configuration nutchConf, CommonCrawlConfig config) throws IOException {
        this.url = url;
        this.content = content;
        this.metadata = metadata;
        this.conf = nutchConf;
        this.keyPrefix = config.getKeyPrefix();
        this.simpleDateFormat = config.getSimpleDateFormat();
        this.jsonArray = config.getJsonArray();
        this.reverseKey = config.getReverseKey();
        this.reverseKeyValue = config.getReverseKeyValue();
    }

    @Override
    public String getJsonData(String url, Content content, Metadata metadata) throws IOException {
        this.url = url;
        this.content = content;
        this.metadata = metadata;
        return this.getJsonData();
    }

    @Override
    public String getJsonData(String url, Content content, Metadata metadata, ParseData parseData) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public String getJsonData() throws IOException {
        try {
            this.startObject(null);
            this.writeKeyValue("url", this.getUrl());
            this.writeKeyValue("timestamp", this.getTimestamp());
            this.startObject("request");
            this.writeKeyValue("method", this.getMethod());
            this.startObject("client");
            this.writeKeyValue("hostname", this.getRequestHostName());
            this.writeKeyValue("address", this.getRequestHostAddress());
            this.writeKeyValue("software", this.getRequestSoftware());
            this.writeKeyValue("robots", this.getRequestRobots());
            this.startObject("contact");
            this.writeKeyValue("name", this.getRequestContactName());
            this.writeKeyValue("email", this.getRequestContactEmail());
            this.closeObject("contact");
            this.closeObject("client");
            this.startHeaders("headers", false, true);
            this.writeKeyValueWrapper("Accept", this.getRequestAccept());
            this.writeKeyValueWrapper("Accept-Encoding", this.getRequestAcceptEncoding());
            this.writeKeyValueWrapper("Accept-Language", this.getRequestAcceptLanguage());
            this.writeKeyValueWrapper("User-Agent", this.getRequestUserAgent());
            this.closeHeaders("headers", false, true);
            this.writeKeyNull("body");
            this.closeObject("request");
            this.startObject("response");
            this.writeKeyValue("status", this.getResponseStatus());
            this.startObject("server");
            this.writeKeyValue("hostname", this.getResponseHostName());
            this.writeKeyValue("address", this.getResponseAddress());
            this.closeObject("server");
            this.startHeaders("headers", false, true);
            this.writeKeyValueWrapper("Content-Encoding", this.getResponseContentEncoding());
            this.writeKeyValueWrapper("Content-Type", this.getResponseContentType());
            this.writeKeyValueWrapper("Date", this.getResponseDate());
            this.writeKeyValueWrapper("Server", this.getResponseServer());
            for (String name : this.metadata.names()) {
                if (name.equalsIgnoreCase("Content-Encoding") || name.equalsIgnoreCase("Content-Type") || name.equalsIgnoreCase("Date") || name.equalsIgnoreCase("Server")) continue;
                this.writeKeyValueWrapper(name, this.metadata.get(name));
            }
            this.closeHeaders("headers", false, true);
            this.writeKeyValue("body", this.getResponseContent());
            this.closeObject("response");
            if (!this.keyPrefix.isEmpty()) {
                this.keyPrefix = this.keyPrefix + "-";
            }
            this.writeKeyValue("key", this.keyPrefix + this.getKey());
            this.writeKeyValue("imported", this.getImported());
            if (this.getInLinks() != null) {
                this.startArray("inlinks", false, true);
                for (String link : this.getInLinks()) {
                    this.writeArrayValue(link);
                }
                this.closeArray("inlinks", false, true);
            }
            this.closeObject(null);
            return this.generateJson();
        }
        catch (IOException ioe) {
            LOG.warn("Error in processing file " + this.url + ": " + ioe.getMessage());
            throw new IOException("Error in generating JSON:" + ioe.getMessage());
        }
    }

    protected abstract void writeKeyValue(String var1, String var2) throws IOException;

    protected abstract void writeKeyNull(String var1) throws IOException;

    protected abstract void startArray(String var1, boolean var2, boolean var3) throws IOException;

    protected abstract void closeArray(String var1, boolean var2, boolean var3) throws IOException;

    protected abstract void writeArrayValue(String var1) throws IOException;

    protected abstract void startObject(String var1) throws IOException;

    protected abstract void closeObject(String var1) throws IOException;

    protected abstract String generateJson() throws IOException;

    protected String getUrl() {
        try {
            return URIUtil.encodePath((String)this.url);
        }
        catch (URIException e) {
            LOG.error("Can't encode URL " + this.url);
            return this.url;
        }
    }

    protected String getTimestamp() {
        if (this.simpleDateFormat) {
            String timestamp = null;
            try {
                long epoch = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z").parse(AbstractCommonCrawlFormat.ifNullString(this.metadata.get("Last-Modified"))).getTime();
                timestamp = String.valueOf(epoch);
            }
            catch (ParseException pe) {
                LOG.warn(pe.getMessage());
            }
            return timestamp;
        }
        return AbstractCommonCrawlFormat.ifNullString(this.metadata.get("Last-Modified"));
    }

    protected String getMethod() {
        return new String("GET");
    }

    protected String getRequestHostName() {
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostName;
    }

    protected String getRequestHostAddress() {
        String hostAddress = "";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostAddress;
    }

    protected String getRequestSoftware() {
        return this.conf.get("http.agent.version", "");
    }

    protected String getRequestRobots() {
        return new String("CLASSIC");
    }

    protected String getRequestContactName() {
        return this.conf.get("http.agent.name", "");
    }

    protected String getRequestContactEmail() {
        return this.conf.get("http.agent.email", "");
    }

    protected String getRequestAccept() {
        return this.conf.get("http.accept", "");
    }

    protected String getRequestAcceptEncoding() {
        return new String("");
    }

    protected String getRequestAcceptLanguage() {
        return this.conf.get("http.accept.language", "");
    }

    protected String getRequestUserAgent() {
        return this.conf.get("http.robots.agents", "");
    }

    protected String getResponseStatus() {
        return AbstractCommonCrawlFormat.ifNullString(this.metadata.get("status"));
    }

    protected String getResponseHostName() {
        return URLUtil.getHost(this.url);
    }

    protected String getResponseAddress() {
        return AbstractCommonCrawlFormat.ifNullString(this.metadata.get("_ip_"));
    }

    protected String getResponseContentEncoding() {
        return AbstractCommonCrawlFormat.ifNullString(this.metadata.get("Content-Encoding"));
    }

    protected String getResponseContentType() {
        return AbstractCommonCrawlFormat.ifNullString(this.metadata.get("Content-Type"));
    }

    @Override
    public List<String> getInLinks() {
        return this.inLinks;
    }

    @Override
    public void setInLinks(List<String> inLinks) {
        this.inLinks = inLinks;
    }

    protected String getResponseDate() {
        if (this.simpleDateFormat) {
            String timestamp = null;
            try {
                long epoch = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").parse(AbstractCommonCrawlFormat.ifNullString(this.metadata.get("Date"))).getTime();
                timestamp = String.valueOf(epoch);
            }
            catch (ParseException pe) {
                LOG.warn(pe.getMessage());
            }
            return timestamp;
        }
        return AbstractCommonCrawlFormat.ifNullString(this.metadata.get("Date"));
    }

    protected String getResponseServer() {
        return AbstractCommonCrawlFormat.ifNullString(this.metadata.get("Server"));
    }

    protected String getResponseContent() {
        return new String(this.content.getContent());
    }

    protected String getKey() {
        if (this.reverseKey) {
            return this.reverseKeyValue;
        }
        return this.url;
    }

    protected String getImported() {
        if (this.simpleDateFormat) {
            String timestamp = null;
            try {
                long epoch = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z").parse(AbstractCommonCrawlFormat.ifNullString(this.metadata.get("Date"))).getTime();
                timestamp = String.valueOf(epoch);
            }
            catch (ParseException pe) {
                LOG.warn(pe.getMessage());
            }
            return timestamp;
        }
        return AbstractCommonCrawlFormat.ifNullString(this.metadata.get("Date"));
    }

    private static String ifNullString(String value) {
        return value != null ? value : "";
    }

    private void startHeaders(String key, boolean nested, boolean newline) throws IOException {
        if (this.jsonArray) {
            this.startArray(key, nested, newline);
        } else {
            this.startObject(key);
        }
    }

    private void closeHeaders(String key, boolean nested, boolean newline) throws IOException {
        if (this.jsonArray) {
            this.closeArray(key, nested, newline);
        } else {
            this.closeObject(key);
        }
    }

    private void writeKeyValueWrapper(String key, String value) throws IOException {
        if (this.jsonArray) {
            this.startArray(null, true, false);
            this.writeArrayValue(key);
            this.writeArrayValue(value);
            this.closeArray(null, true, false);
        } else {
            this.writeKeyValue(key, value);
        }
    }

    @Override
    public void close() {
    }
}

