/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.service.resources;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.nutch.service.NutchReader;
import org.apache.nutch.service.impl.LinkReader;
import org.apache.nutch.service.impl.NodeReader;
import org.apache.nutch.service.impl.SequenceReader;
import org.apache.nutch.service.model.request.ReaderConfig;

@Path(value="/reader")
public class ReaderResouce {
    @Path(value="/sequence/read")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response seqRead(ReaderConfig readerConf, @DefaultValue(value="-1") @QueryParam(value="nrows") int nrows, @DefaultValue(value="-1") @QueryParam(value="start") int start, @QueryParam(value="end") int end, @QueryParam(value="count") boolean count) {
        SequenceReader reader = new SequenceReader();
        String path = readerConf.getPath();
        return this.performRead(reader, path, nrows, start, end, count);
    }

    @Path(value="/link")
    @GET
    @Produces(value={"application/json"})
    public Response linkRead() {
        HashMap<String, String> schema = new HashMap<String, String>();
        schema.put("key_url", "string");
        schema.put("timestamp", "int");
        schema.put("score", "float");
        schema.put("anchor", "string");
        schema.put("linktype", "string");
        schema.put("url", "string");
        return Response.ok(schema).type("application/json").build();
    }

    @Path(value="/link/read")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response linkRead(ReaderConfig readerConf, @DefaultValue(value="-1") @QueryParam(value="nrows") int nrows, @DefaultValue(value="-1") @QueryParam(value="start") int start, @QueryParam(value="end") int end, @QueryParam(value="count") boolean count) {
        LinkReader reader = new LinkReader();
        String path = readerConf.getPath();
        return this.performRead(reader, path, nrows, start, end, count);
    }

    @Path(value="/node")
    @GET
    @Produces(value={"application/json"})
    public Response nodeRead() {
        HashMap<String, String> schema = new HashMap<String, String>();
        schema.put("key_url", "string");
        schema.put("num_inlinks", "int");
        schema.put("num_outlinks", "int");
        schema.put("inlink_score", "float");
        schema.put("outlink_score", "float");
        schema.put("metadata", "string");
        return Response.ok(schema).type("application/json").build();
    }

    @Path(value="/node/read")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response nodeRead(ReaderConfig readerConf, @DefaultValue(value="-1") @QueryParam(value="nrows") int nrows, @DefaultValue(value="-1") @QueryParam(value="start") int start, @QueryParam(value="end") int end, @QueryParam(value="count") boolean count) {
        NodeReader reader = new NodeReader();
        String path = readerConf.getPath();
        return this.performRead(reader, path, nrows, start, end, count);
    }

    private Response performRead(NutchReader reader, String path, int nrows, int start, int end, boolean count) {
        try {
            if (count) {
                Integer result = reader.count(path);
                return Response.ok((Object)result).type("text/plain").build();
            }
            List result = start > -1 && end > 0 ? reader.slice(path, start, end) : (nrows > -1 ? reader.head(path, nrows) : reader.read(path));
            return Response.ok((Object)result).type("application/json").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"File not found").build();
        }
    }
}

