/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.service.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.scoring.webgraph.Node;
import org.apache.nutch.service.NutchReader;

public class NodeReader
implements NutchReader {
    @Override
    public List read(String path) throws FileNotFoundException {
        ArrayList<HashMap<String, String>> rows = new ArrayList<HashMap<String, String>>();
        Path file = new Path(path);
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Node value = new Node();
            while (reader.next(key, (Writable)value)) {
                try {
                    HashMap<String, String> t_row = this.getNodeRow(key, value);
                    rows.add(t_row);
                }
                catch (Exception exception) {}
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return rows;
    }

    @Override
    public List head(String path, int nrows) throws FileNotFoundException {
        ArrayList<HashMap<String, String>> rows = new ArrayList<HashMap<String, String>>();
        Path file = new Path(path);
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Node value = new Node();
            for (int i = 0; reader.next(key, (Writable)value) && i < nrows; ++i) {
                HashMap<String, String> t_row = this.getNodeRow(key, value);
                rows.add(t_row);
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return rows;
    }

    @Override
    public List slice(String path, int start, int end) throws FileNotFoundException {
        ArrayList<HashMap<String, String>> rows = new ArrayList<HashMap<String, String>>();
        Path file = new Path(path);
        try {
            int i;
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Node value = new Node();
            for (i = 0; i < start && reader.next(key, (Writable)value); ++i) {
            }
            while (reader.next(key, (Writable)value) && i < end) {
                HashMap<String, String> t_row = this.getNodeRow(key, value);
                rows.add(t_row);
                ++i;
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return rows;
    }

    @Override
    public int count(String path) throws FileNotFoundException {
        Path file = new Path(path);
        int i = 0;
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Node value = new Node();
            while (reader.next(key, (Writable)value)) {
                ++i;
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return i;
    }

    private HashMap<String, String> getNodeRow(Writable key, Node value) {
        HashMap<String, String> tRow = new HashMap<String, String>();
        tRow.put("key_url", key.toString());
        tRow.put("num_inlinks", String.valueOf(value.getNumInlinks()));
        tRow.put("num_outlinks", String.valueOf(value.getNumOutlinks()));
        tRow.put("inlink_score", String.valueOf(value.getInlinkScore()));
        tRow.put("outlink_score", String.valueOf(value.getOutlinkScore()));
        tRow.put("metadata", value.getMetadata().toString());
        return tRow;
    }
}

