/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.segment;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.nutch.util.HadoopFSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentChecker {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static boolean isIndexable(Path segmentPath, FileSystem fs) throws IOException {
        if (segmentPath == null || fs == null) {
            LOG.info("No segment path or filesystem set.");
            return false;
        }
        boolean checkResult = true;
        return checkResult &= SegmentChecker.checkSegmentDir(segmentPath, fs);
    }

    public static boolean checkSegmentDir(Path segmentPath, FileSystem fs) throws IOException {
        if (segmentPath.getName().length() != 14) {
            LOG.warn("The input path at {} is not a segment... skipping", (Object)segmentPath.getName());
            return false;
        }
        FileStatus[] fstats_segment = fs.listStatus(segmentPath, HadoopFSUtil.getPassDirectoriesFilter(fs));
        Path[] segment_files = HadoopFSUtil.getPaths(fstats_segment);
        boolean crawlFetchExists = false;
        boolean crawlParseExists = false;
        boolean parseDataExists = false;
        boolean parseTextExists = false;
        for (Path path : segment_files) {
            String pathName = path.getName();
            crawlFetchExists |= pathName.equals("crawl_fetch");
            crawlParseExists |= pathName.equals("crawl_parse");
            parseDataExists |= pathName.equals("parse_data");
            parseTextExists |= pathName.equals("parse_text");
        }
        if (parseTextExists && crawlParseExists && crawlFetchExists && parseDataExists) {
            LOG.info("Segment dir is complete: " + segmentPath.toString() + ".");
            return true;
        }
        StringBuilder missingDir = new StringBuilder("");
        if (!parseDataExists) {
            missingDir.append("parse_data, ");
        }
        if (!parseTextExists) {
            missingDir.append("parse_text, ");
        }
        if (!crawlParseExists) {
            missingDir.append("crawl_parse, ");
        }
        if (!crawlFetchExists) {
            missingDir.append("crawl_fetch, ");
        }
        String missingDirString = missingDir.toString();
        LOG.warn("Skipping segment: " + segmentPath.toString() + ". Missing sub directories: " + missingDirString.substring(0, missingDirString.length() - 2));
        return false;
    }

    public static boolean isParsed(Path segment, FileSystem fs) throws IOException {
        return fs.exists(new Path(segment, "crawl_parse"));
    }
}

