/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.plugin;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nutch.plugin.PluginRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLStreamHandlerFactory
implements java.net.URLStreamHandlerFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(URLStreamHandlerFactory.class);
    private static URLStreamHandlerFactory instance;
    private ArrayList<WeakReference<PluginRepository>> prs = new ArrayList();
    private Map<String, Optional<URLStreamHandler>> cache;
    public static final String[] SYSTEM_PROTOCOLS;

    private URLStreamHandlerFactory() {
        this.initCache();
    }

    private synchronized void initCache() {
        this.cache = new ConcurrentHashMap<String, Optional<URLStreamHandler>>();
        for (String protocol : SYSTEM_PROTOCOLS) {
            this.cache.put(protocol, Optional.empty());
        }
    }

    public static URLStreamHandlerFactory getInstance() {
        return instance;
    }

    public void registerPluginRepository(PluginRepository pr) {
        this.prs.add(new WeakReference<PluginRepository>(pr));
        this.initCache();
        this.removeInvalidRefs();
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (this.cache.containsKey(protocol)) {
            return this.cache.get(protocol).orElse(null);
        }
        LOG.debug("Creating URLStreamHandler for protocol: {}", (Object)protocol);
        this.removeInvalidRefs();
        for (WeakReference<PluginRepository> ref : this.prs) {
            PluginRepository pr = (PluginRepository)ref.get();
            if (pr == null) continue;
            URLStreamHandler handler = pr.createURLStreamHandler(protocol);
            this.cache.put(protocol, Optional.of(handler));
            return handler;
        }
        this.cache.put(protocol, Optional.empty());
        return null;
    }

    private void removeInvalidRefs() {
        ArrayList<WeakReference<PluginRepository>> copy = new ArrayList<WeakReference<PluginRepository>>(this.prs);
        for (WeakReference<PluginRepository> ref : copy) {
            if (ref.get() != null) continue;
            this.prs.remove(ref);
        }
        LOG.debug("Removed '{}' invalid references. '{}' remaining.", (Object)(copy.size() - this.prs.size()), (Object)this.prs.size());
    }

    static {
        SYSTEM_PROTOCOLS = new String[]{"http", "https", "file", "jar"};
        instance = new URLStreamHandlerFactory();
        URL.setURLStreamHandlerFactory(instance);
        LOG.debug("Registered URLStreamHandlerFactory with the JVM.");
    }
}

