/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.parse.ParsePluginList;
import org.apache.nutch.parse.ParsePluginsReader;
import org.apache.nutch.parse.Parser;
import org.apache.nutch.parse.ParserNotFound;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.util.MimeUtil;
import org.apache.nutch.util.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParserFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DEFAULT_PLUGIN = "*";
    private final List<Extension> EMPTY_EXTENSION_LIST = Collections.emptyList();
    private Configuration conf;
    private ExtensionPoint extensionPoint;
    private ParsePluginList parsePluginList;

    public ParserFactory(Configuration conf) {
        this.conf = conf;
        ObjectCache objectCache = ObjectCache.get(conf);
        this.extensionPoint = PluginRepository.get(conf).getExtensionPoint(Parser.X_POINT_ID);
        this.parsePluginList = (ParsePluginList)objectCache.getObject(ParsePluginList.class.getName());
        if (this.parsePluginList == null) {
            this.parsePluginList = new ParsePluginsReader().parse(conf);
            objectCache.setObject(ParsePluginList.class.getName(), this.parsePluginList);
        }
        if (this.extensionPoint == null) {
            throw new RuntimeException("x point " + Parser.X_POINT_ID + " not found.");
        }
        if (this.parsePluginList == null) {
            throw new RuntimeException("Parse Plugins preferences could not be loaded.");
        }
    }

    public Parser[] getParsers(String contentType, String url) throws ParserNotFound {
        Vector<Parser> parsers = null;
        List<Extension> parserExts = null;
        ObjectCache objectCache = ObjectCache.get(this.conf);
        parserExts = this.getExtensions(contentType);
        if (parserExts == null) {
            throw new ParserNotFound(url, contentType);
        }
        parsers = new Vector<Parser>(parserExts.size());
        for (Extension ext : parserExts) {
            Parser p = null;
            try {
                p = (Parser)objectCache.getObject(ext.getId());
                if (p == null) {
                    p = (Parser)ext.getExtensionInstance();
                    objectCache.setObject(ext.getId(), p);
                }
                parsers.add(p);
            }
            catch (PluginRuntimeException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("ParserFactory:PluginRuntimeException when initializing parser plugin " + ext.getDescriptor().getPluginId() + " instance because: " + e.getMessage() + " - attempting to continue instantiating parsers", (Throwable)e);
            }
        }
        return parsers.toArray(new Parser[0]);
    }

    public Parser getParserById(String id) throws ParserNotFound {
        Extension[] extensions = this.extensionPoint.getExtensions();
        Extension parserExt = null;
        ObjectCache objectCache = ObjectCache.get(this.conf);
        if (id != null) {
            parserExt = this.getExtension(extensions, id);
        }
        if (parserExt == null) {
            parserExt = this.getExtensionFromAlias(extensions, id);
        }
        if (parserExt == null) {
            throw new ParserNotFound("No Parser Found for id [" + id + "]");
        }
        if (objectCache.getObject(parserExt.getId()) != null) {
            return (Parser)objectCache.getObject(parserExt.getId());
        }
        try {
            Parser p = (Parser)parserExt.getExtensionInstance();
            objectCache.setObject(parserExt.getId(), p);
            return p;
        }
        catch (PluginRuntimeException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Canno initialize parser " + parserExt.getDescriptor().getPluginId() + " (cause: " + e.toString());
            }
            throw new ParserNotFound("Cannot init parser for id [" + id + "]");
        }
    }

    protected List<Extension> getExtensions(String contentType) {
        ObjectCache objectCache = ObjectCache.get(this.conf);
        String type = null;
        type = MimeUtil.cleanMimeType(contentType);
        List<Extension> extensions = (List<Extension>)objectCache.getObject(type);
        if (extensions == this.EMPTY_EXTENSION_LIST) {
            return null;
        }
        if (extensions == null) {
            extensions = this.findExtensions(type);
            if (extensions != null) {
                objectCache.setObject(type, extensions);
            } else {
                objectCache.setObject(type, this.EMPTY_EXTENSION_LIST);
            }
        }
        return extensions;
    }

    private List<Extension> findExtensions(String contentType) {
        Extension[] extensions = this.extensionPoint.getExtensions();
        List<String> parsePluginList = this.parsePluginList.getPluginList(contentType);
        List<Extension> extensionList = this.matchExtensions(parsePluginList, extensions, contentType);
        if (extensionList != null) {
            return extensionList;
        }
        parsePluginList = this.parsePluginList.getPluginList(DEFAULT_PLUGIN);
        return this.matchExtensions(parsePluginList, extensions, DEFAULT_PLUGIN);
    }

    private List<Extension> matchExtensions(List<String> plugins, Extension[] extensions, String contentType) {
        ArrayList<Extension> extList = new ArrayList<Extension>();
        if (plugins != null) {
            for (String parsePluginId : plugins) {
                Extension ext = this.getExtension(extensions, parsePluginId, contentType);
                if (ext == null) {
                    ext = this.getExtension(extensions, parsePluginId);
                    if (LOG.isWarnEnabled()) {
                        if (ext != null) {
                            LOG.warn("ParserFactory:Plugin: " + parsePluginId + " mapped to contentType " + contentType + " via parse-plugins.xml, but its plugin.xml file does not claim to support contentType: " + contentType);
                        } else {
                            LOG.warn("ParserFactory: Plugin: " + parsePluginId + " mapped to contentType " + contentType + " via parse-plugins.xml, but not enabled via plugin.includes in nutch-default.xml");
                        }
                    }
                }
                if (ext == null) continue;
                extList.add(ext);
            }
        } else {
            for (int i = 0; i < extensions.length; ++i) {
                if (DEFAULT_PLUGIN.equals(extensions[i].getAttribute("contentType"))) {
                    extList.add(0, extensions[i]);
                    continue;
                }
                if (extensions[i].getAttribute("contentType") == null || !contentType.matches(this.escapeContentType(extensions[i].getAttribute("contentType")))) continue;
                extList.add(extensions[i]);
            }
            if (extList.size() > 0) {
                if (LOG.isInfoEnabled()) {
                    StringBuffer extensionsIDs = new StringBuffer("[");
                    boolean isFirst = true;
                    for (Extension ext : extList) {
                        if (!isFirst) {
                            extensionsIDs.append(" - ");
                        } else {
                            isFirst = false;
                        }
                        extensionsIDs.append(ext.getId());
                    }
                    extensionsIDs.append("]");
                    LOG.info("The parsing plugins: " + extensionsIDs.toString() + " are enabled via the plugin.includes system property, and all claim to support the content type " + contentType + ", but they are not mapped to it  in the parse-plugins.xml file");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("ParserFactory:No parse plugins mapped or enabled for contentType " + contentType);
            }
        }
        return extList.size() > 0 ? extList : null;
    }

    private String escapeContentType(String contentType) {
        return contentType.replace("+", "\\+").replace(".", "\\.");
    }

    private boolean match(Extension extension, String id, String type) {
        return id.equals(extension.getId()) && (extension.getAttribute("contentType").equals(DEFAULT_PLUGIN) || type.matches(this.escapeContentType(extension.getAttribute("contentType"))) || type.equals(DEFAULT_PLUGIN));
    }

    private Extension getExtension(Extension[] list, String id, String type) {
        for (int i = 0; i < list.length; ++i) {
            if (!this.match(list[i], id, type)) continue;
            return list[i];
        }
        return null;
    }

    private Extension getExtension(Extension[] list, String id) {
        for (int i = 0; i < list.length; ++i) {
            if (!id.equals(list[i].getId())) continue;
            return list[i];
        }
        return null;
    }

    private Extension getExtensionFromAlias(Extension[] list, String id) {
        return this.getExtension(list, this.parsePluginList.getAliases().get(id));
    }
}

