/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.parse.Outlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlinkExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern URL_PATTERN = Pattern.compile("([A-Za-z][A-Za-z0-9+.-]{1,120}:[A-Za-z0-9/](([A-Za-z0-9$_.+!*,;/?:@&~=-])|%[A-Fa-f0-9]{2}){1,333}(#([a-zA-Z0-9][a-zA-Z0-9$_.+!*,;/?:@&~=%-]{0,1000}))?)");

    public static Outlink[] getOutlinks(String plainText, Configuration conf) {
        return OutlinkExtractor.getOutlinks(plainText, "", conf);
    }

    public static Outlink[] getOutlinks(String plainText, String anchor, Configuration conf) {
        ArrayList<Outlink> outlinks;
        block8: {
            if (plainText == null) {
                return new Outlink[0];
            }
            long start = System.currentTimeMillis();
            outlinks = new ArrayList<Outlink>();
            try {
                Matcher matcher = URL_PATTERN.matcher(plainText);
                while (matcher.find()) {
                    if (System.currentTimeMillis() - start >= 60000L) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Time limit exceeded for getOutLinks");
                        }
                        break;
                    }
                    String url = matcher.group().trim();
                    try {
                        outlinks.add(new Outlink(url, anchor));
                    }
                    catch (MalformedURLException mue) {
                        LOG.warn("Invalid url: '" + url + "', skipping.");
                    }
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error("getOutlinks", (Throwable)ex);
            }
        }
        Outlink[] retval = outlinks.size() > 0 ? outlinks.toArray(new Outlink[0]) : new Outlink[]{};
        return retval;
    }
}

