/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net;

import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLNormalizer;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.util.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLNormalizers {
    public static final String SCOPE_DEFAULT = "default";
    public static final String SCOPE_PARTITION = "partition";
    public static final String SCOPE_GENERATE_HOST_COUNT = "generate_host_count";
    public static final String SCOPE_FETCHER = "fetcher";
    public static final String SCOPE_CRAWLDB = "crawldb";
    public static final String SCOPE_LINKDB = "linkdb";
    public static final String SCOPE_INJECT = "inject";
    public static final String SCOPE_OUTLINK = "outlink";
    public static final String SCOPE_INDEXER = "indexer";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<Extension> EMPTY_EXTENSION_LIST = Collections.emptyList();
    private final URLNormalizer[] EMPTY_NORMALIZERS = new URLNormalizer[0];
    private Configuration conf;
    private ExtensionPoint extensionPoint;
    private URLNormalizer[] normalizers;
    private int loopCount;

    public URLNormalizers(Configuration conf, String scope) {
        this.conf = conf;
        this.extensionPoint = PluginRepository.get(conf).getExtensionPoint(URLNormalizer.X_POINT_ID);
        ObjectCache objectCache = ObjectCache.get(conf);
        if (this.extensionPoint == null) {
            throw new RuntimeException("x point " + URLNormalizer.X_POINT_ID + " not found.");
        }
        this.normalizers = (URLNormalizer[])objectCache.getObject(URLNormalizer.X_POINT_ID + "_" + scope);
        if (this.normalizers == null) {
            this.normalizers = this.getURLNormalizers(scope);
        }
        if (this.normalizers == this.EMPTY_NORMALIZERS) {
            this.normalizers = (URLNormalizer[])objectCache.getObject(URLNormalizer.X_POINT_ID + "_default");
            if (this.normalizers == null) {
                this.normalizers = this.getURLNormalizers(SCOPE_DEFAULT);
            }
        }
        this.loopCount = conf.getInt("urlnormalizer.loop.count", 1);
    }

    URLNormalizer[] getURLNormalizers(String scope) {
        List<Extension> extensions = this.getExtensions(scope);
        ObjectCache objectCache = ObjectCache.get(this.conf);
        if (extensions == this.EMPTY_EXTENSION_LIST) {
            return this.EMPTY_NORMALIZERS;
        }
        Vector<URLNormalizer> normalizers = new Vector<URLNormalizer>(extensions.size());
        for (Extension ext : extensions) {
            URLNormalizer normalizer = null;
            try {
                normalizer = (URLNormalizer)objectCache.getObject(ext.getId());
                if (normalizer == null) {
                    normalizer = (URLNormalizer)ext.getExtensionInstance();
                    objectCache.setObject(ext.getId(), normalizer);
                }
                normalizers.add(normalizer);
            }
            catch (PluginRuntimeException e) {
                e.printStackTrace();
                LOG.warn("URLNormalizers:PluginRuntimeException when initializing url normalizer plugin " + ext.getDescriptor().getPluginId() + " instance in getURLNormalizers function: attempting to continue instantiating plugins");
            }
        }
        return normalizers.toArray(new URLNormalizer[normalizers.size()]);
    }

    private List<Extension> getExtensions(String scope) {
        ObjectCache objectCache = ObjectCache.get(this.conf);
        List<Extension> extensions = (List<Extension>)objectCache.getObject(URLNormalizer.X_POINT_ID + "_x_" + scope);
        if (extensions == this.EMPTY_EXTENSION_LIST) {
            return this.EMPTY_EXTENSION_LIST;
        }
        if (extensions == null) {
            extensions = this.findExtensions(scope);
            if (extensions != null) {
                objectCache.setObject(URLNormalizer.X_POINT_ID + "_x_" + scope, extensions);
            } else {
                objectCache.setObject(URLNormalizer.X_POINT_ID + "_x_" + scope, this.EMPTY_EXTENSION_LIST);
                extensions = this.EMPTY_EXTENSION_LIST;
            }
        }
        return extensions;
    }

    private List<Extension> findExtensions(String scope) {
        String[] orders = null;
        String orderlist = this.conf.get("urlnormalizer.order." + scope);
        if (orderlist == null) {
            orderlist = this.conf.get("urlnormalizer.order");
        }
        if (orderlist != null && !orderlist.trim().equals("")) {
            orders = orderlist.trim().split("\\s+");
        }
        String scopelist = this.conf.get("urlnormalizer.scope." + scope);
        HashSet<String> impls = null;
        if (scopelist != null && !scopelist.trim().equals("")) {
            String[] names = scopelist.split("\\s+");
            impls = new HashSet<String>(Arrays.asList(names));
        }
        Extension[] extensions = this.extensionPoint.getExtensions();
        HashMap<String, Extension> normalizerExtensions = new HashMap<String, Extension>();
        for (int i = 0; i < extensions.length; ++i) {
            Extension extension = extensions[i];
            if (impls != null && !impls.contains(extension.getClazz())) continue;
            normalizerExtensions.put(extension.getClazz(), extension);
        }
        ArrayList<Extension> res = new ArrayList<Extension>();
        if (orders == null) {
            res.addAll(normalizerExtensions.values());
        } else {
            for (int i = 0; i < orders.length; ++i) {
                Extension e = (Extension)normalizerExtensions.get(orders[i]);
                if (e == null) continue;
                res.add(e);
                normalizerExtensions.remove(orders[i]);
            }
            res.addAll(normalizerExtensions.values());
        }
        return res;
    }

    public String normalize(String urlString, String scope) throws MalformedURLException {
        String initialString = urlString;
        for (int k = 0; k < this.loopCount; ++k) {
            for (int i = 0; i < this.normalizers.length; ++i) {
                if (urlString == null) {
                    return null;
                }
                urlString = this.normalizers[i].normalize(urlString, scope);
            }
            if (initialString.equals(urlString)) break;
            initialString = urlString;
        }
        return urlString;
    }
}

