/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.nutch.metadata.HttpHeaders;
import org.apache.nutch.metadata.Metadata;

public class SpellCheckedMetadata
extends Metadata {
    private static final int TRESHOLD_DIVIDER = 3;
    private static final Map<String, String> NAMES_IDX;
    private static String[] normalized;

    private static String normalize(String str) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c)) continue;
            buf.append(Character.toLowerCase(c));
        }
        return buf.toString();
    }

    public static String getNormalizedName(String name) {
        String searched = SpellCheckedMetadata.normalize(name);
        String value = NAMES_IDX.get(searched);
        if (value == null && normalized != null) {
            int threshold = Math.min(3, searched.length() / 3);
            for (int i = 0; i < normalized.length && value == null; ++i) {
                if (StringUtils.getLevenshteinDistance((String)searched, (String)normalized[i]) >= threshold) continue;
                value = NAMES_IDX.get(normalized[i]);
            }
        }
        return value != null ? value : name;
    }

    @Override
    public void remove(String name) {
        super.remove(SpellCheckedMetadata.getNormalizedName(name));
    }

    @Override
    public void add(String name, String value) {
        super.add(SpellCheckedMetadata.getNormalizedName(name), value);
    }

    @Override
    public String[] getValues(String name) {
        return super.getValues(SpellCheckedMetadata.getNormalizedName(name));
    }

    @Override
    public String get(String name) {
        return super.get(SpellCheckedMetadata.getNormalizedName(name));
    }

    @Override
    public void set(String name, String value) {
        super.set(SpellCheckedMetadata.getNormalizedName(name), value);
    }

    static {
        Class[] spellthese;
        NAMES_IDX = new HashMap<String, String>();
        normalized = null;
        for (Class spellCheckedNames : spellthese = new Class[]{HttpHeaders.class}) {
            for (Field field : spellCheckedNames.getFields()) {
                int mods = field.getModifiers();
                if (!Modifier.isFinal(mods) || !Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !field.getType().equals(String.class)) continue;
                try {
                    String val = (String)field.get(null);
                    NAMES_IDX.put(SpellCheckedMetadata.normalize(val), val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        normalized = NAMES_IDX.keySet().toArray(new String[NAMES_IDX.size()]);
    }
}

